/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import noppes.animalbikes.ABItems;
import noppes.animalbikes.entity.types.EntityRidable;
import noppes.animalbikes.logic.DinoLogic;

public class EntityDinoBike
extends EntityRidable
implements IEntityAdditionalSpawnData {
    private static final DataParameter<CompoundNBT> DW_GRABBED = EntityDataManager.func_187226_a(EntityDinoBike.class, (IDataSerializer)DataSerializers.field_192734_n);
    public DinoLogic logic = new DinoLogic(this, DW_GRABBED);

    public EntityDinoBike(EntityType<EntityRidable> entityEntityType, World world) {
        super(entityEntityType, world);
        this.canColor = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_GRABBED, (Object)new CompoundNBT());
    }

    @Override
    public boolean func_70104_M() {
        return this.logic.getGrabbedEntity() == null;
    }

    public void func_70108_f(Entity entity) {
        this.logic.applyEntityCollision(entity);
        super.func_70108_f(entity);
    }

    @Override
    public Item getWheel() {
        return ABItems.dino;
    }

    public void func_70071_h_() {
        AnimalEntity grabbed = this.getGrabbedEntity();
        if (grabbed != null) {
            for (Entity riddenByEntity : this.func_184188_bt()) {
                if (!riddenByEntity.func_70093_af()) continue;
                this.logic.spawnGrabbed();
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("AnimalGrabbed", (INBT)this.logic.getCompound());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.logic.setCompound(compound.func_74775_l("AnimalGrabbed"));
    }

    public void func_70106_y() {
        this.logic.spawnGrabbed();
        super.func_70106_y();
    }

    public double func_70042_X() {
        return 0.9;
    }

    public AnimalEntity getGrabbedEntity() {
        return this.logic.getGrabbedEntity();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        this.func_213281_b(compound);
        buffer.func_150786_a(compound);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_70037_a(additionalData.func_150793_b());
    }
}

