/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import noppes.animalbikes.ABEntities;
import noppes.animalbikes.ABItems;
import noppes.animalbikes.entity.EntityThrownItem;
import noppes.animalbikes.entity.types.EntityRidable;
import noppes.animalbikes.entity.types.EntityRidableFlying;

public class EntityDragonBike
extends EntityRidableFlying {
    public double[][] field_40162_d = new double[64][3];
    public int field_40164_e = -1;
    public float prevAnimTime = 0.0f;
    public float animTime = 0.0f;
    public int field_40178_aA = 0;
    public long breathFire = 0L;
    public boolean isFlying = false;
    public float ticks = 0.0f;

    public EntityDragonBike(EntityType<EntityRidable> entityEntityType, World world) {
        super(ABEntities.DragonBike, world);
        if (this.isSpecial()) {
            // empty if block
        }
        entityEntityType.func_220338_c();
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.isSpecial()) {
            // empty if block
        }
    }

    @Override
    public Item getWheel() {
        return ABItems.dragon;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
    }

    public double func_70042_X() {
        return this.isSpecial() ? 2.6 : 1.1;
    }

    @Override
    public void rightClicked(ItemStack item, PlayerEntity player) {
        if (item.func_77973_b() == Items.field_151033_d && this.breathFire == 0L) {
            this.breathFire = System.currentTimeMillis();
            item.func_222118_a(1, (LivingEntity)player, p_220009_1_ -> p_220009_1_.func_213334_d(player.func_184600_cs()));
        }
    }

    public double[] getMovementOffsets(int i, float f) {
        double d1;
        f = 1.0f - f;
        int j = this.field_40164_e - i * 1 & 0x3F;
        int k = this.field_40164_e - i * 1 - 1 & 0x3F;
        double[] ad = new double[3];
        double d = this.field_40162_d[j][0];
        for (d1 = this.field_40162_d[k][0] - d; d1 < -180.0; d1 += 360.0) {
        }
        while (d1 >= 180.0) {
            d1 -= 360.0;
        }
        ad[0] = d + d1 * (double)f;
        d = this.field_40162_d[j][1];
        d1 = this.field_40162_d[k][1] - d;
        ad[1] = d + d1 * (double)f;
        ad[2] = this.field_40162_d[j][2] + (this.field_40162_d[k][2] - this.field_40162_d[j][2]) * (double)f;
        return ad;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.breathFire + 300L < System.currentTimeMillis()) {
            this.breathFire = 0L;
        }
        if (this.breathFire > 0L && !this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0) {
            boolean bo;
            EntityThrownItem fire = new EntityThrownItem((LivingEntity)this, new ItemStack((IItemProvider)Blocks.field_150480_ab), 0, this.field_70170_p);
            fire.fireChance = 3;
            double x = this.field_70165_t;
            double y = this.field_70163_u;
            double z = this.field_70161_v;
            double f = this.field_70146_Z.nextDouble() * 0.8 + 0.5;
            double f1 = -this.field_70146_Z.nextDouble();
            if (f1 > -0.5) {
                f1 = -0.5;
            }
            double f2 = this.field_70146_Z.nextDouble() * 0.8 + 0.5;
            double dx = -MathHelper.func_76126_a((float)((float)((double)(this.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.field_70125_A / 180.0f) * Math.PI)));
            double dz = MathHelper.func_76134_b((float)((float)((double)(this.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.field_70125_A / 180.0f) * Math.PI)));
            int size = this.isSpecial() ? 6 : 3;
            fire.func_70107_b(x + dx * (double)size, y + 0.5, z + dz * (double)size);
            double motionX = dx * f + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
            double motionY = f1 + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
            double motionZ = dz * f2 + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
            float var14 = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
            float var15 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
            motionX = motionX / (double)var15 * (double)var14 * (double)0.4f;
            motionY = motionY / (double)var15 * (double)var14 * (double)0.4f + (double)0.1f;
            motionZ = motionZ / (double)var15 * (double)var14 * (double)0.4f;
            motionX *= 0.01;
            motionY *= 0.01;
            motionZ *= 0.01;
            motionX += dx * f;
            motionY += f1;
            motionZ += dz * f2;
            boolean bl = bo = !this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v));
            if (bo) {
                motionY = 0.14;
                fire.field_70125_A = 0.0f;
            }
            fire.func_213293_j(motionX, motionY, motionZ);
            this.field_70170_p.func_217376_c((Entity)fire);
        }
        if (this.field_70170_p.field_72995_K && !this.field_70122_E) {
            float f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            float f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, SoundCategory.AMBIENT, 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.func_110143_aJ() <= 0.0f) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f4 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f2, this.field_70161_v + (double)f4, 0.0, 0.0, 0.0);
            return;
        }
        Vec3d motion = this.func_213322_ci();
        float f1 = 0.2f / (MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c)) * 10.0f + 1.0f);
        f1 = 0.045f;
        this.animTime += (f1 *= (float)Math.pow(2.0, motion.field_72448_b)) * 0.5f;
        while (this.field_70177_z >= 180.0f) {
            this.field_70177_z -= 360.0f;
        }
        while (this.field_70177_z < -180.0f) {
            this.field_70177_z += 360.0f;
        }
        if (this.field_40164_e < 0) {
            for (int i = 0; i < this.field_40162_d.length; ++i) {
                this.field_40162_d[i][0] = this.field_70177_z + 180.0f;
                this.field_40162_d[i][1] = this.field_70163_u;
            }
        }
        if (++this.field_40164_e == this.field_40162_d.length) {
            this.field_40164_e = 0;
        }
        this.field_40162_d[this.field_40164_e][0] = this.field_70177_z + 180.0f;
        this.field_40162_d[this.field_40164_e][1] = this.field_70163_u;
        this.field_70761_aq = this.field_70177_z + 180.0f;
        super.func_70636_d();
    }

    public void func_184232_k(Entity passenger) {
        if (passenger == null) {
            super.func_184232_k(passenger);
        } else {
            float f6 = this.prevAnimTime + (this.animTime - this.prevAnimTime) * this.ticks;
            float f7 = (float)(Math.sin(f6 * 3.141593f * 2.0f - 1.0f) + 1.0);
            if (this.isSpecial()) {
                f7 *= 2.0f;
            }
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() - (double)(f7 / 12.0f), this.field_70161_v);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187526_aP;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }
}

