/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import noppes.animalbikes.ABItems;
import noppes.animalbikes.entity.types.EntityRidable;

public class EntityIrongolemBike
extends EntityRidable {
    private static final DataParameter<Integer> DW_ANIMATION = EntityDataManager.func_187226_a(EntityIrongolemBike.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int lastAttackedTicks;
    public float ticks = 0.0f;

    public EntityIrongolemBike(EntityType<EntityRidable> entityEntityType, World world) {
        super(entityEntityType, world);
        this.walkSpeed = 0.04f;
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_ANIMATION, (Object)0);
    }

    @Override
    public Item getWheel() {
        return ABItems.irongolem;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(140.0);
    }

    public double func_70042_X() {
        return 1.8;
    }

    protected int func_70682_h(int par1) {
        return par1;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAttackAnimation() > 0) {
            this.setAttackAnimation(this.getAttackAnimation() - 1);
        }
        if (this.lastAttackedTicks > 0) {
            --this.lastAttackedTicks;
        }
    }

    @Override
    public void func_70664_aZ() {
        if (!this.field_70170_p.field_72995_K && this.lastAttackedTicks <= 0 && this.field_70122_E && this.rider != null) {
            boolean flag;
            this.setAttackAnimation(10);
            this.lastAttackedTicks = 20;
            List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72321_a(2.0, 2.0, 2.0));
            LivingEntity toAttack = null;
            float distance = 5.0f;
            for (LivingEntity entity : list) {
                float dis;
                if (entity == this || entity == this.rider || !this.func_70685_l((Entity)entity) || !((dis = this.func_70032_d((Entity)entity)) < distance)) continue;
                toAttack = entity;
                distance = dis;
            }
            boolean bl = flag = toAttack != null && toAttack.func_70097_a(DamageSource.func_76365_a((PlayerEntity)this.rider), (float)(8 + this.field_70146_Z.nextInt(6)));
            if (flag) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.4, 0.0));
            }
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (passenger == null) {
            super.func_184232_k(passenger);
            return;
        }
        if ((double)this.field_70721_aZ < 0.01) {
            super.func_184232_k(passenger);
            return;
        }
        float f = 13.0f;
        float f1 = this.field_184619_aG - this.field_70721_aZ * (1.0f - this.ticks) + 6.0f;
        float f2 = (Math.abs(f1 % f - f * 0.5f) - f * 0.25f) / (f * 0.25f);
        double d = MathHelper.func_76126_a((float)((float)((double)(this.field_70761_aq / 180.0f) * Math.PI)));
        double d2 = MathHelper.func_76134_b((float)((float)((double)(this.field_70761_aq / 180.0f) * Math.PI)));
        passenger.func_70107_b(this.field_70165_t + (double)f2 * d2 / 4.0, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + (double)f2 * d / 4.0);
    }

    public int getAttackAnimation() {
        return (Integer)this.field_70180_af.func_187225_a(DW_ANIMATION);
    }

    public void setAttackAnimation(int tick) {
        this.field_70180_af.func_187227_b(DW_ANIMATION, (Object)tick);
    }
}

