/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import noppes.animalbikes.ABItems;
import noppes.animalbikes.entity.types.EntityRidable;

public class EntitySilverfishBike
extends EntityRidable {
    private static final DataParameter<Boolean> DW_BIG = EntityDataManager.func_187226_a(EntitySilverfishBike.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int destroyTimer = 0;

    public EntitySilverfishBike(EntityType<EntityRidable> entityEntityType, World world) {
        super(entityEntityType, world);
        this.walkSpeed = 0.15f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_BIG, (Object)false);
    }

    @Override
    public Item getWheel() {
        return ABItems.silverfish;
    }

    public double func_70042_X() {
        if (this.isBigger()) {
            return 0.2;
        }
        return 0.1;
    }

    public boolean isBigger() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_BIG);
    }

    private void setBigger(boolean flag) {
        this.field_70180_af.func_187227_b(DW_BIG, (Object)flag);
    }

    public void func_70071_h_() {
        this.field_70761_aq = this.field_70177_z;
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.rider != null && !this.field_70170_p.field_72995_K) {
            this.destroyBlocksInAABB();
        }
    }

    private void destroyBlocksInAABB() {
        if (this.destroyTimer > 0) {
            if (this.destroyTimer == 3) {
                this.setBigger(false);
            }
            --this.destroyTimer;
            return;
        }
        if (this.field_70703_bu) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)this.rider;
        if (!player.field_71075_bZ.field_75099_e) {
            return;
        }
        ItemStack item = player.func_184614_ca();
        if (item == null || !(item.func_77973_b() instanceof PickaxeItem)) {
            return;
        }
        double dx = -MathHelper.func_76126_a((float)((float)((double)(this.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.field_70125_A / 180.0f) * Math.PI)));
        double dz = MathHelper.func_76134_b((float)((float)((double)(this.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.field_70125_A / 180.0f) * Math.PI)));
        BlockPos pos = new BlockPos(this.field_70165_t + dx, this.field_70163_u, this.field_70161_v + dz);
        this.mine(player, pos);
        this.mine(player, pos.func_177984_a());
        if (this.func_70093_af()) {
            this.mine(player, pos.func_177977_b());
        }
        if (this.isBigger()) {
            item.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
    }

    private void mine(ServerPlayerEntity player, BlockPos pos) {
        BlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null) {
            return;
        }
        if (state.func_196952_d((IBlockReader)this.field_70170_p, pos).func_197766_b()) {
            return;
        }
        if (!state.func_185904_a().func_76220_a()) {
            return;
        }
        if (block.func_176195_g(state, (IBlockReader)this.field_70170_p, pos) < 0.0f) {
            return;
        }
        this.field_70170_p.func_217377_a(pos, false);
        this.field_70170_p.func_217378_a((PlayerEntity)player, 2001, pos, Block.func_196246_j((BlockState)state));
        block.func_180657_a(this.field_70170_p, (PlayerEntity)player, pos, state, this.field_70170_p.func_175625_s(pos), ItemStack.field_190927_a);
        this.destroyTimer = 30;
        this.setBigger(true);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187852_fb, SoundCategory.AMBIENT, 1.0f, 1.0f);
    }
}

