/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import noppes.animalbikes.ABEntities;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.entity.EntityThrownItem2;

public class EntityThrownItem
extends EntityThrownItem2 {
    private static final DataParameter<Boolean> DW_ROTATING = EntityDataManager.func_187226_a(EntityThrownItem.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DW_EXPLODING = EntityDataManager.func_187226_a(EntityThrownItem.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DW_FLOATING = EntityDataManager.func_187226_a(EntityThrownItem.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> DW_ITEM = EntityDataManager.func_187226_a(EntityThrownItem.class, (IDataSerializer)DataSerializers.field_187196_f);
    private int damage = 2;
    public ItemEntity ItemEntity;
    public int age = 0;
    public ItemStack dropItem = null;
    public float hoverStart = (float)(Math.random() * Math.PI * 2.0);
    public int fireChance = 0;

    public EntityThrownItem(EntityType<? extends EntityThrownItem> entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public EntityThrownItem(LivingEntity entity, ItemStack itemstack, int damage, World world) {
        super((EntityType<? extends EntityThrownItem2>)ABEntities.EntityThrownItem, entity, world);
        this.setItem(itemstack);
        this.damage = damage;
    }

    public EntityThrownItem(World p_i50150_1_, LivingEntity p_i50150_2_) {
        super((EntityType<? extends EntityThrownItem2>)ABEntities.EntityThrownItem, p_i50150_2_, p_i50150_1_);
    }

    public EntityThrownItem(LivingEntity entity, float par3, int damage, World world) {
        super((EntityType<? extends EntityThrownItem2>)ABEntities.EntityThrownItem, entity, world);
        this.damage = damage;
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.20000000149011612;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.shoot(par3);
    }

    public void shoot(float speed) {
        double x = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double z = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.shoot(x, y, z, speed, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(DW_ROTATING, (Object)false);
        this.field_70180_af.func_187214_a(DW_FLOATING, (Object)false);
        this.field_70180_af.func_187214_a(DW_EXPLODING, (Object)false);
    }

    public boolean isRotating() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_ROTATING);
    }

    public void setRotating() {
        this.field_70180_af.func_187227_b(DW_ROTATING, (Object)true);
    }

    public boolean isFloating() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_FLOATING);
    }

    public void setFloating(boolean floating) {
        this.field_70180_af.func_187227_b(DW_FLOATING, (Object)floating);
    }

    public boolean isExplosive() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_EXPLODING);
    }

    public void setExplosive(boolean explosive) {
        this.field_70180_af.func_187227_b(DW_EXPLODING, (Object)explosive);
    }

    public void setItem(ItemStack itemstack) {
        this.field_70180_af.func_187227_b(DW_ITEM, (Object)itemstack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(DW_ITEM);
    }

    @Override
    public void func_70071_h_() {
        ++this.age;
        if (!this.field_70170_p.field_72995_K && this.age > 50) {
            this.func_70106_y();
        }
        if (this.isFloating()) {
            return;
        }
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            Vec3d motion = this.func_213322_ci();
            float f = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motion.field_72450_a, motion.field_72449_c) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motion.field_72448_b, f) * 180.0 / Math.PI);
        }
        if (this.isRotating()) {
            this.field_70125_A -= (float)(this.age * 2);
        }
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Age", this.age);
        if (this.getItem() != null) {
            compound.func_218657_a("Item", (INBT)this.getItem().func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.age = compound.func_74762_e("Age");
        ItemStack item = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        if (item.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.setItem(item);
        }
    }

    public Iterable<ItemStack> func_184193_aE() {
        return NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    @Override
    protected void onImpact(RayTraceResult movingobjectposition) {
        EntityRayTraceResult eray;
        Entity entity;
        if (movingobjectposition.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult bray = (BlockRayTraceResult)movingobjectposition;
            BlockPos pos = bray.func_216350_a();
            BlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_196952_d((IBlockReader)this.field_70170_p, pos).func_197766_b()) {
                return;
            }
            if (!this.field_70170_p.field_72995_K && this.func_184102_h().func_71218_a(DimensionType.field_223227_a_).func_82736_K().func_223586_b(AnimalBikes.TERRAIN_DAMAGE) && this.fireChance > 0 && this.field_70170_p.field_73012_v.nextInt(this.fireChance) == 1 && !this.field_70170_p.func_175623_d(pos)) {
                this.setFire(pos.func_177977_b());
                this.setFire(pos.func_177984_a());
                this.setFire(pos.func_177968_d());
                this.setFire(pos.func_177974_f());
                this.setFire(pos.func_177978_c());
                this.setFire(pos.func_177976_e());
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.isExplosive()) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0, 0.0, 0.0);
            }
            return;
        }
        if (movingobjectposition.func_216346_c() == RayTraceResult.Type.ENTITY && (entity = (eray = (EntityRayTraceResult)movingobjectposition).func_216348_a()) != null) {
            if (this.fireChance > 0) {
                if (!entity.func_70045_F()) {
                    entity.func_70097_a(DamageSource.field_76372_a, 3.0f);
                    entity.func_70015_d(5);
                }
            } else {
                entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.getThrower()), (float)this.damage);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.dropItem != null) {
                this.func_70099_a(this.dropItem, 0.0f);
            }
            if (this.isExplosive()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 0.8f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
            this.func_70106_y();
        }
    }

    private void setFire(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151579_a) {
            return;
        }
        this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
    }

    public void func_70106_y() {
        super.func_70106_y();
    }
}

