/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import noppes.animalbikes.ABItems;
import noppes.animalbikes.entity.types.EntityRidable;

public class EntityWolfBike
extends EntityRidable {
    private static final DataParameter<Boolean> DW_ANGRY = EntityDataManager.func_187226_a(EntityWolfBike.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityWolfBike(EntityType<EntityRidable> entityEntityType, World world) {
        super(entityEntityType, world);
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public boolean func_70652_k(Entity par1Entity) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return par1Entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_ANGRY, (Object)false);
    }

    @Override
    public Item getWheel() {
        return ABItems.wolf;
    }

    @Override
    public boolean panics() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public boolean func_70631_g_() {
        return this.isSpecial();
    }

    public double func_70042_X() {
        if (this.isSpecial()) {
            return 0.15;
        }
        return 0.5;
    }

    protected SoundEvent func_184639_G() {
        if (this.isWolfAngry()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    private boolean playerHoldingBone(PlayerEntity player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        return item != null && item.func_77973_b() == Items.field_151103_aS;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.rider != null) {
            if (!this.playerHoldingBone(this.rider)) {
                if (this.func_70638_az() == null) {
                    Iterator iterator;
                    ArrayList list = new ArrayList();
                    list.addAll(this.field_70170_p.func_217357_a(MobEntity.class, this.func_174813_aQ().func_72321_a(10.0, 4.0, 10.0)));
                    if (this.field_70170_p.field_73012_v.nextInt(15) == 1) {
                        list.addAll(this.field_70170_p.func_217357_a(SheepEntity.class, this.func_174813_aQ().func_72321_a(10.0, 4.0, 10.0)));
                    }
                    if ((iterator = list.iterator()).hasNext()) {
                        Entity entity = (Entity)iterator.next();
                        this.func_70624_b((LivingEntity)entity);
                        this.setWolfAngry(true);
                        return;
                    }
                    this.setWolfAngry(false);
                } else {
                    this.rider.func_184210_p();
                }
            } else {
                this.setWolfAngry(false);
                this.func_70624_b(null);
            }
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.8f;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (entity != null && entity == this.rider) {
            return false;
        }
        if (super.func_70097_a(damagesource, i)) {
            if (this.rider != null && this.playerHoldingBone(this.rider)) {
                return true;
            }
            if (!this.isWolfAngry()) {
                if (entity instanceof PlayerEntity) {
                    this.setWolfAngry(true);
                    this.func_70624_b((LivingEntity)entity);
                }
                if (entity instanceof ArrowEntity && ((ArrowEntity)entity).field_70250_c != null) {
                    this.func_70624_b((LivingEntity)((ArrowEntity)entity).func_212360_k());
                    this.setWolfAngry(true);
                }
            }
        }
        return true;
    }

    public float setTailRotation() {
        if (this.isWolfAngry()) {
            return 1.53938f;
        }
        return 0.9738938f;
    }

    public boolean isWolfAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_ANGRY);
    }

    public void setWolfAngry(boolean flag) {
        this.field_70180_af.func_187227_b(DW_ANGRY, (Object)flag);
    }

    public boolean isWolfTamed() {
        return true;
    }
}

