/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity.types;

import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import noppes.animalbikes.ai.EntityAIBikePanic;
import noppes.animalbikes.ai.EntityBikeAIWander;

public abstract class EntityRidable
extends CreatureEntity {
    private static final DataParameter<String> DW_OWNER = EntityDataManager.func_187226_a(EntityRidable.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> DW_COLOR = EntityDataManager.func_187226_a(EntityRidable.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DW_SPECIAL = EntityDataManager.func_187226_a(EntityRidable.class, (IDataSerializer)DataSerializers.field_187198_h);
    public PlayerEntity rider;
    public float walkSpeed = 0.22f;
    public boolean canColor = true;

    public EntityRidable(EntityType<? extends CreatureEntity> type, World world) {
        super(type, world);
        this.func_70661_as().func_212239_d(true);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        if (this.panics()) {
            this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIBikePanic(this, 2.0));
        }
        if (this.wanders()) {
            this.field_70714_bg.func_75776_a(2, (Goal)new EntityBikeAIWander(this, 1.0));
            this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
            this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        }
        if (world != null && !world.field_72995_K && this.field_70146_Z.nextInt(5) == 1) {
            this.setIsSpecial(true);
        }
        this.setColor(this.getRandomColor());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_OWNER, (Object)"");
        this.field_70180_af.func_187214_a(DW_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(DW_SPECIAL, (Object)false);
    }

    public boolean panics() {
        return true;
    }

    public boolean wanders() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
    }

    public boolean isSpecial() {
        return (Boolean)this.field_70180_af.func_187225_a(DW_SPECIAL);
    }

    public void setIsSpecial(boolean flag) {
        this.field_70180_af.func_187227_b(DW_SPECIAL, (Object)flag);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Owner", this.getOwner());
        compound.func_74768_a("Color", this.getColor());
        compound.func_74757_a("Special", this.isSpecial());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setOwner(compound.func_74779_i("Owner"));
        this.setColor(compound.func_74762_e("Color"));
        this.setIsSpecial(compound.func_74767_n("Special"));
    }

    public void func_70642_aH() {
        if (this.func_70681_au().nextInt(8) == 1) {
            super.func_70642_aH();
        }
    }

    public void func_70636_d() {
        if (this.func_184207_aI()) {
            for (Entity passengers : this.func_184188_bt()) {
                if (!(passengers instanceof PlayerEntity)) continue;
                this.rider = (PlayerEntity)passengers;
            }
        } else {
            this.rider = null;
        }
        if (this.rider != null && this.rider.field_70703_bu) {
            this.func_70683_ar().func_75660_a();
        }
        super.func_70636_d();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return this.func_184207_aI();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L || hand != Hand.MAIN_HAND) {
            return false;
        }
        if (!this.getOwner().isEmpty() && !player.func_110124_au().toString().equals(this.getOwner())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Not owned by you", new Object[0]));
            return false;
        }
        if (this.rider != null) {
            return false;
        }
        ItemStack item = player.func_184586_b(hand);
        if (item.func_77973_b() instanceof DyeItem && this.canColor) {
            int i = DyeColor.getColor((ItemStack)item).func_196060_f();
            if (this.getColor() != i) {
                this.setColor(i);
                this.consumeItem(player, item);
                return true;
            }
        }
        if (player.func_70093_af() && item.func_190926_b()) {
            player.func_184611_a(hand, new ItemStack((IItemProvider)this.getWheel()));
            this.field_70128_L = true;
            return true;
        }
        if (!player.func_70093_af()) {
            this.mount(player);
            return true;
        }
        return true;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.func_199702_a((IItemProvider)this.getWheel(), 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_94059_bO() {
        return this.func_174833_aM();
    }

    public void consumeItem(PlayerEntity player, ItemStack item) {
        item.func_190918_g(1);
        if (item.func_190926_b()) {
            player.field_71071_by.func_184437_d(item);
        }
    }

    public void setOwner(String owner) {
        this.field_70180_af.func_187227_b(DW_OWNER, (Object)owner);
    }

    public String getOwner() {
        return (String)this.field_70180_af.func_187225_a(DW_OWNER);
    }

    public void setColor(int i) {
        this.field_70180_af.func_187227_b(DW_COLOR, (Object)i);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(DW_COLOR);
    }

    public void func_213352_e(Vec3d vec) {
        if (this.rider != null) {
            this.field_70126_B = this.field_70177_z = this.rider.field_70177_z;
            this.field_70125_A = this.rider.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            vec = new Vec3d((double)(this.rider.field_70702_br * 0.5f), vec.field_72448_b, (double)this.rider.field_191988_bg);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e(this.walkSpeed);
                super.func_213352_e(vec);
            } else {
                super.func_213352_e(vec);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_213352_e(vec);
        }
    }

    public int getRandomColor() {
        return this.func_70681_au().nextInt(16);
    }

    public void func_70664_aZ() {
        Vec3d vec3d = this.func_213322_ci();
        double motionY = 0.5;
        if (this.func_70644_a(Effects.field_76430_j)) {
            motionY += (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        float f = this.field_70177_z * ((float)Math.PI / 180);
        double motionX = vec3d.field_72450_a - (double)(MathHelper.func_76126_a((float)f) * 0.2f);
        double motionZ = vec3d.field_72449_c + (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        this.func_213293_j(motionX, motionY, motionZ);
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    private void mount(PlayerEntity par1PlayerEntity) {
        par1PlayerEntity.field_70177_z = this.field_70177_z;
        par1PlayerEntity.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            par1PlayerEntity.func_184220_m((Entity)this);
        }
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public abstract Item getWheel();

    public void rightClicked(ItemStack item, PlayerEntity player) {
    }

    public boolean func_70051_ag() {
        if (this.rider == null) {
            return false;
        }
        return this.rider.field_191988_bg > 0.5f;
    }
}

