/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import noppes.animalbikes.ABEntities;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.AnimalBikesPermissions;
import noppes.animalbikes.entity.EntityPonyBike;
import noppes.animalbikes.entity.EntityPonyFlyingBike;
import noppes.animalbikes.entity.types.EntityRidable;
import noppes.animalbikes.items.ItemAnimalBike;

public class ItemPonyBike
extends ItemAnimalBike {
    public static final List<String> textures = new ArrayList<String>();
    public static final List<String> dyablePonies = new ArrayList<String>();

    @Override
    public EntityRidable getBike(World world) {
        int rand = world.field_73012_v.nextInt(textures.size());
        byte b = ItemPonyBike.getType(rand);
        if (b == 2 || b == 3) {
            EntityPonyFlyingBike pony = new EntityPonyFlyingBike((EntityType<EntityRidable>)ABEntities.PonyFlyingBike, world);
            pony.setType(b);
            pony.setColor(rand);
            return pony;
        }
        EntityPonyBike pony = new EntityPonyBike((EntityType<EntityRidable>)ABEntities.PonyBike, world);
        pony.setType(b);
        pony.setColor(rand);
        return pony;
    }

    public static byte getType(int index) {
        String texture = textures.get(index);
        if (texture.startsWith("animalbikes:textures/entity/ponies/alicorn")) {
            return 3;
        }
        if (texture.startsWith("animalbikes:textures/entity/ponies/pegasus")) {
            return 2;
        }
        if (texture.startsWith("animalbikes:textures/entity/ponies/unicorn")) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canUse(PlayerEntity player) {
        return !AnimalBikes.DisablePony && AnimalBikesPermissions.hasPermission(player, "animalbikes.pony.use");
    }

    @Override
    public boolean isBike(EntityRidable entity) {
        return EntityPonyBike.class.isInstance((Object)entity) || EntityPonyFlyingBike.class.isInstance((Object)entity);
    }

    static {
        if (textures.isEmpty()) {
            textures.add("animalbikes:textures/entity/ponies/alicorn/minelp_princess_celestia.png");
            textures.add("animalbikes:textures/entity/ponies/alicorn/minelp_princess_luna_s2.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_aloe.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_apple_bloom.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_applejack.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_berry_punch.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_big_mac.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_bon_bon.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_caramel.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_carrot_top.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_cheerilee.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_cherry.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_doctor_whooves.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_golden_harvest.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_lotus.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_nurse_redheart.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_octavia.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_pinkie_pie.png");
            textures.add("animalbikes:textures/entity/ponies/earth/minelp_roseluck.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_blueberry_muffin.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_brolly.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_cherries_jubilee.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_cloud_kicker.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_derpy_hooves.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_endless_clouds.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_fluttershy.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_orange_box.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_pegasus_guard.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_rainbow_dash.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_raindrop.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_roy_g_bow.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_scootaloo.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_soarin.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_spitfire.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_under_d_weather.png");
            textures.add("animalbikes:textures/entity/ponies/pegasus/minelp_velvet_hooves.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_chocolate_sun.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_colgate.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_crescent.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_dj_pon3.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_heartstrings.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_holly_dash.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_lemon_hearts.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_lemon_tart.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_lyra.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_north_pole.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_orchid_dew.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_rarity.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_sparkler.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_star_sparkle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_sweetie_belle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_trixie.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_twilight_sparkle.png");
            textures.add("animalbikes:textures/entity/ponies/unicorn/minelp_unicorn_guard.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/alicorn/minelp_princess_luna_s2.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/minelp_big_mac.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp_lyra.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp_chocolate_sun.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/minelp_rainbow_dash.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp_rarity.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp_heartstrings.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/minelp_derpy_hooves.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/minelp_octavia.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/minelp_pinkie_pie.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/minelp_under_d_weather.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/pegasus/minelp_fluttershy.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp_dj_pon3.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/unicorn/minelp_twilight_sparkle.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/earth/minelp_applejack.png");
            dyablePonies.add("animalbikes:textures/entity/ponies/alicorn/minelp_princess_celestia.png");
        }
    }
}

