/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.logic;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import noppes.animalbikes.entity.types.EntityRidable;

public class DinoLogic {
    private final DataParameter<CompoundNBT> DW_GRABBED;
    private long lastGrabbed = 0L;
    private AnimalEntity entity;
    private EntityRidable bike;

    public DinoLogic(EntityRidable bike, DataParameter<CompoundNBT> DW_GRABBED) {
        this.bike = bike;
        this.DW_GRABBED = DW_GRABBED;
    }

    public void applyEntityCollision(Entity entity) {
        if (entity == this.bike.rider) {
            return;
        }
        if (!this.bike.field_70170_p.field_72995_K && this.bike.rider != null && this.getCompound().isEmpty() && entity instanceof AnimalEntity && this.lastGrabbed + 2000L < System.currentTimeMillis()) {
            AnimalEntity grabbed = (AnimalEntity)entity;
            CompoundNBT compound = new CompoundNBT();
            grabbed.func_70039_c(compound);
            this.setCompound(compound);
            entity = grabbed;
            grabbed.field_70128_L = true;
        }
    }

    public void spawnGrabbed() {
        if (!this.bike.field_70170_p.field_72995_K && !this.getCompound().isEmpty()) {
            Optional animal = EntityType.func_220330_a((CompoundNBT)this.getCompound(), (World)this.bike.field_70170_p);
            if (!animal.isPresent()) {
                return;
            }
            Entity e = (Entity)animal.get();
            double dx = -MathHelper.func_76126_a((float)((float)((double)(this.bike.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70125_A / 180.0f) * Math.PI)));
            double dz = MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70177_z / 180.0f) * Math.PI))) * MathHelper.func_76134_b((float)((float)((double)(this.bike.field_70125_A / 180.0f) * Math.PI)));
            e.func_70107_b(this.bike.field_70165_t + dx, this.bike.field_70163_u, this.bike.field_70161_v + dz);
            this.bike.field_70170_p.func_217376_c(e);
        }
        this.setCompound(new CompoundNBT());
        this.entity = null;
        this.lastGrabbed = System.currentTimeMillis();
    }

    public CompoundNBT getCompound() {
        return (CompoundNBT)this.bike.func_184212_Q().func_187225_a(this.DW_GRABBED);
    }

    public void setCompound(CompoundNBT compound) {
        this.bike.func_184212_Q().func_187227_b(this.DW_GRABBED, (Object)compound);
    }

    public AnimalEntity getGrabbedEntity() {
        if (this.getCompound().isEmpty()) {
            return null;
        }
        if (this.entity != null) {
            return this.entity;
        }
        Optional animal = EntityType.func_220330_a((CompoundNBT)this.getCompound(), (World)this.bike.field_70170_p);
        return animal.map(value -> {
            this.entity = (AnimalEntity)value;
            return this.entity;
        }).orElseGet(() -> {
            this.entity = null;
            return null;
        });
    }
}

