/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.capabilities.aov;

import Tamaized.AoV.AoV;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.core.abilities.Aura;
import Tamaized.AoV.core.skills.AoVSkill;
import Tamaized.AoV.network.ClientPacketHandler;
import Tamaized.AoV.network.ServerPacketHandler;
import Tamaized.AoV.registry.AoVPotions;
import Tamaized.TamModized.helper.FloatyTextHelper;
import Tamaized.TamModized.helper.PacketHelper;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AoVCapabilityHandler
implements IAoVCapability {
    public static final float xpScale = 2.5f;
    private int tick = 1;
    private boolean dirty = false;
    private int currentSlot = 0;
    private List<AoVSkill> obtainedSkills = new ArrayList<AoVSkill>();
    private int skillPoints = 1;
    private int exp = 0;
    private int maxLevel = 15;
    private boolean invokeMass = false;
    private Ability[] slots = new Ability[]{null, null, null, null, null, null, null, null, null};
    private List<Ability> abilities = new ArrayList<Ability>();
    private float spellpower = 0.0f;
    private int extraCharges = 0;
    private int dodge = 0;
    private int doublestrike = 0;
    private boolean selectiveFocus = false;
    private boolean hasInvoke = false;
    private List<Aura> auras = new ArrayList<Aura>();
    private Map<AbilityBase, DecayWrapper> decay = new HashMap<AbilityBase, DecayWrapper>();
    private int lastLevel = -1;
    private static final String defenderHealthName = "AoV Defender Health";
    private static final AttributeModifier defenderHealth = new AttributeModifier("AoV Defender Health", 10.0, 0);

    public static int getExpForLevel(IAoVCapability cap, int level) {
        return level > cap.getMaxLevel() ? 0 : AoVCapabilityHandler.getExpForLevel(level);
    }

    public static int getExpForLevel(int level) {
        return level < 1 ? 0 : (int)Math.floor(25.0f * ((2.5f + (float)(level - 2)) * (float)(level - 1)));
    }

    public static int getLevelFromExp(float xp) {
        double a = (-12.5 + Math.sqrt(25.0 * Math.pow(2.5, 2.0) - 125.0 + (double)(4.0f * (xp += 0.5f)) + 25.0) + 15.0) / 10.0;
        double b = (-12.5 - Math.sqrt(25.0 * Math.pow(2.5, 2.0) - 125.0 + (double)(4.0f * xp) + 25.0) + 15.0) / 10.0;
        return Math.max((int)a, (int)b);
    }

    @Override
    public void reset(boolean b) {
        if (b) {
            this.obtainedSkills.clear();
            this.skillPoints = 1;
            this.exp = 0;
            this.maxLevel = 15;
            this.lastLevel = -1;
        } else {
            AoVSkill core = this.getCoreSkill();
            this.obtainedSkills.clear();
            this.obtainedSkills.add(core);
            this.skillPoints = this.getLevel() - 1;
        }
        this.abilities.clear();
        this.auras.clear();
        this.decay.clear();
        this.invokeMass = false;
        this.slots = new Ability[]{null, null, null, null, null, null, null, null, null};
        this.dirty = true;
    }

    @Override
    public void update(EntityPlayer player) {
        if (this.tick > 0 && this.tick % 20 == 0) {
            this.updateAbilities();
        }
        this.updateAuras(player);
        this.updateDecay();
        if (this.dirty) {
            this.updateValues(player);
            if (player instanceof EntityPlayerMP) {
                this.sendPacketUpdates((EntityPlayerMP)player);
            }
            this.dirty = false;
        }
        this.updateHealth(player);
        if (this.tick > 0 && this.tick % 600 == 0 && this.hasSkill(AoVSkill.defender_capstone) && player != null) {
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            if (main != null && main.func_77973_b() instanceof ItemShield && main.func_77973_b().isRepairable() && main.func_77952_i() > 0) {
                main.func_77964_b(0);
            }
            if (off != null && off.func_77973_b() instanceof ItemShield && off.func_77973_b().isRepairable() && off.func_77952_i() > 0) {
                off.func_77964_b(0);
            }
        }
        ++this.tick;
    }

    private void updateHealth(EntityPlayer player) {
        if (player == null) {
            return;
        }
        IAttributeInstance hp = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        for (AttributeModifier mod : hp.func_111122_c()) {
            if (!mod.func_111166_b().equals(defenderHealthName)) continue;
            hp.func_111124_b(mod);
        }
        if (this.hasSkill(AoVSkill.defender_tier_4_2) && !hp.func_180374_a(defenderHealth)) {
            hp.func_111121_a(defenderHealth);
        }
    }

    private void updateValues(EntityPlayer player) {
        if (this.lastLevel < 0) {
            this.lastLevel = this.getLevel();
        }
        if (this.lastLevel < this.getLevel()) {
            this.skillPoints += this.getLevel() - this.lastLevel;
            this.lastLevel = this.getLevel();
        }
        this.spellpower = 0.0f;
        this.extraCharges = 0;
        this.dodge = 0;
        this.doublestrike = 0;
        this.selectiveFocus = false;
        this.hasInvoke = false;
        ArrayList<AbilityBase> list = new ArrayList<AbilityBase>();
        this.abilities.clear();
        for (AoVSkill skill : this.obtainedSkills) {
            this.spellpower += (float)skill.getBuffs().spellPower;
            this.extraCharges += skill.getBuffs().charges;
            this.dodge += skill.getBuffs().dodge;
            this.doublestrike += skill.getBuffs().doublestrike;
            if (skill.getBuffs().selectiveFocus) {
                this.selectiveFocus = true;
            }
            for (AbilityBase ability : skill.getAbilities()) {
                if (ability == AbilityBase.invokeMass) {
                    this.hasInvoke = true;
                }
                list.add(ability);
            }
        }
        for (AbilityBase ability : list) {
            this.addAbility(new Ability(ability, this));
        }
        if (player != null) {
            if (player.func_70660_b(AoVPotions.aid) != null) {
                this.dodge += 5;
            }
            if (player.func_70660_b(AoVPotions.zeal) != null) {
                this.doublestrike += 25;
            }
        }
    }

    private void updateAbilities() {
        for (Ability ability : this.slots) {
            if (ability == null) continue;
            ability.update(this);
        }
    }

    private void updateAuras(EntityPlayer player) {
        Iterator<Aura> iter = this.auras.iterator();
        while (iter.hasNext()) {
            Aura aura = iter.next();
            aura.update(player);
            if (!aura.isDead()) continue;
            iter.remove();
        }
    }

    private void updateDecay() {
        Iterator<DecayWrapper> iter = this.decay.values().iterator();
        while (iter.hasNext()) {
            DecayWrapper wrapper = iter.next();
            wrapper.update();
            if (wrapper.getDecay() > 0) continue;
            iter.remove();
        }
    }

    @Override
    public void resetCharges() {
        for (Ability ability : this.slots) {
            if (ability == null) continue;
            ability.reset(this);
        }
        this.dirty = true;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean canUseAbility(Ability ability) {
        this.dirty = true;
        boolean flag = false;
        for (Ability a : this.abilities) {
            if (!a.compare(ability) || !ability.canUse(this)) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public void addAbility(Ability ability) {
        this.abilities.add(ability);
        this.dirty = true;
    }

    @Override
    public void removeAbility(Ability ability) {
        Iterator<Ability> iter = this.abilities.iterator();
        while (iter.hasNext()) {
            Ability a = iter.next();
            if (!a.compare(ability)) continue;
            iter.remove();
            this.dirty = true;
        }
    }

    @Override
    public void addAura(Aura aura) {
        Iterator<Aura> iter = this.auras.iterator();
        while (iter.hasNext()) {
            Aura a = iter.next();
            if (!a.equals(aura)) continue;
            iter.remove();
        }
        this.auras.add(aura);
        this.dirty = true;
    }

    @Override
    public void addExp(Entity player, int amount, AbilityBase spell) {
        if (!this.hasCoreSkill() || this.getLevel() >= this.getMaxLevel()) {
            return;
        }
        if (spell != null) {
            if (this.decay.containsKey(spell)) {
                amount /= this.decay.get(spell).getDecay();
                this.decay.get(spell).addDecay();
            } else {
                this.decay.put(spell, new DecayWrapper());
            }
        }
        if (player instanceof EntityPlayerMP) {
            FloatyTextHelper.sendText((EntityPlayer)((EntityPlayerMP)player), (String)("+" + amount + " Exp"));
        }
        int tempLevel = this.getLevel();
        this.exp += amount;
        if (player instanceof EntityPlayerMP && this.getLevel() > tempLevel) {
            FloatyTextHelper.sendText((EntityPlayer)((EntityPlayerMP)player), (String)("Level Up! (" + this.getLevel() + ")"));
        }
        this.dirty = true;
    }

    @Override
    public void addObtainedSkill(AoVSkill skill) {
        if (!this.obtainedSkills.contains(skill)) {
            this.obtainedSkills.add(skill);
            this.dirty = true;
        }
    }

    @Override
    public boolean hasSkill(AoVSkill skill) {
        return this.obtainedSkills.contains(skill);
    }

    @Override
    public boolean hasCoreSkill() {
        for (AoVSkill skill : this.obtainedSkills) {
            if (!skill.isClassCore()) continue;
            return true;
        }
        return false;
    }

    @Override
    public AoVSkill getCoreSkill() {
        for (AoVSkill skill : this.obtainedSkills) {
            if (!skill.isClassCore()) continue;
            return skill;
        }
        return null;
    }

    @Override
    public List<AoVSkill> getObtainedSkills() {
        return this.obtainedSkills;
    }

    @Override
    public void removeSkill(AoVSkill skill) {
        this.obtainedSkills.remove(skill);
        this.dirty = true;
    }

    @Override
    public int getLevel() {
        return AoVCapabilityHandler.getLevelFromExp(this.exp);
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public void setMaxLevel(int amount) {
        this.maxLevel = amount;
        this.dirty = true;
    }

    @Override
    public int getExp() {
        return this.exp;
    }

    @Override
    public void setExp(int amount) {
        this.exp = amount;
        this.dirty = true;
    }

    @Override
    public int getExpNeededToLevel() {
        return this.getLevel() >= this.maxLevel ? 0 : AoVCapabilityHandler.getExpForLevel(this, this.getLevel() + 1) - this.exp;
    }

    @Override
    public int getSkillPoints() {
        return this.skillPoints;
    }

    @Override
    public void setSkillPoints(int amount) {
        this.skillPoints = amount;
        this.dirty = true;
    }

    @Override
    public int getSpentSkillPoints() {
        return this.getLevel() - this.skillPoints;
    }

    @Override
    public float getSpellPower() {
        return this.spellpower;
    }

    @Override
    public int getExtraCharges() {
        return this.extraCharges;
    }

    @Override
    public int getDodge() {
        return this.dodge;
    }

    @Override
    public int getDoubleStrike() {
        return this.doublestrike;
    }

    @Override
    public boolean hasSelectiveFocus() {
        return this.selectiveFocus;
    }

    @Override
    public void toggleInvokeMass(boolean b) {
        this.invokeMass = this.hasInvoke ? b : false;
        this.dirty = true;
    }

    @Override
    public void toggleInvokeMass() {
        this.invokeMass = this.hasInvoke ? !this.invokeMass : false;
        this.dirty = true;
    }

    @Override
    public boolean getInvokeMass() {
        return this.invokeMass;
    }

    @Override
    public boolean hasInvokeMass() {
        return this.hasInvoke;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void cast(int slotLoc) {
        try {
            PacketHelper.PacketWrapper packet = PacketHelper.createPacket((FMLEventChannel)AoV.channel, (String)"AoV", (int)ServerPacketHandler.getPacketTypeID(ServerPacketHandler.PacketType.CAST_SPELL));
            packet.getStream().writeInt(slotLoc);
            packet.sendPacketToServer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSlot(Ability ability, int slot) {
        boolean flag = false;
        for (Ability check : this.getAbilities()) {
            if (!check.compare(ability)) continue;
            flag = true;
        }
        if (flag && slot >= 0 && slot < this.slots.length) {
            this.slots[slot] = ability;
        }
        this.dirty = true;
    }

    @Override
    public Ability getSlot(int slot) {
        return slot >= 0 && slot < this.slots.length ? this.slots[slot] : null;
    }

    @Override
    public int getSlotFromAbility(Ability ability) {
        int index = 0;
        for (Ability a : this.slots) {
            if (a != null && ability.compare(a)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int getCurrentSlot() {
        return this.currentSlot;
    }

    @Override
    public void setCurrentSlot(int index) {
        this.currentSlot = index;
        this.dirty = true;
    }

    @Override
    public boolean slotsContain(Ability ability) {
        for (Ability a : this.slots) {
            if (a == null || !ability.compare(a)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addToNearestSlot(Ability ability) {
        if (this.slotsContain(ability)) {
            return;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] != null) continue;
            this.setSlot(ability, i);
            break;
        }
        this.dirty = true;
    }

    @Override
    public void removeSlot(int slot) {
        if (slot >= 0 && slot < this.slots.length) {
            this.slots[slot] = null;
        }
        this.dirty = true;
    }

    @Override
    public void clearAllSlots() {
        this.slots = new Ability[]{null, null, null, null, null, null, null, null, null};
        this.dirty = true;
    }

    @Override
    public void copyFrom(IAoVCapability cap) {
        this.obtainedSkills = cap.getObtainedSkills();
        this.skillPoints = cap.getSkillPoints();
        this.exp = cap.getExp();
        this.maxLevel = cap.getMaxLevel();
        this.invokeMass = cap.getInvokeMass();
        for (int index = 0; index < 9; ++index) {
            this.slots[index] = cap.getSlot(index);
        }
        this.currentSlot = cap.getCurrentSlot();
        this.setDecayMap(cap.getDecayMap());
        this.dirty = true;
    }

    @Override
    public void setDecayMap(Map<AbilityBase, DecayWrapper> map) {
        this.decay.clear();
        this.decay.putAll(map);
    }

    @Override
    public Map<AbilityBase, DecayWrapper> getDecayMap() {
        return Collections.unmodifiableMap(this.decay);
    }

    private void sendPacketUpdates(EntityPlayerMP player) {
        ByteBufOutputStream bos = new ByteBufOutputStream(Unpooled.buffer());
        DataOutputStream stream = new DataOutputStream((OutputStream)bos);
        try {
            stream.writeInt(ClientPacketHandler.getPacketTypeID(ClientPacketHandler.PacketType.AOVDATA));
            stream.writeInt(this.obtainedSkills.size());
            for (AoVSkill skill : this.obtainedSkills) {
                stream.writeInt(skill.getID());
            }
            stream.writeInt(this.skillPoints);
            stream.writeInt(this.exp);
            stream.writeInt(this.maxLevel);
            stream.writeBoolean(this.invokeMass);
            for (int index = 0; index < 9; ++index) {
                Ability ability = this.slots[index];
                if (ability == null) {
                    stream.writeBoolean(false);
                    continue;
                }
                stream.writeBoolean(true);
                ability.encode(stream);
            }
            stream.writeInt(this.currentSlot);
            FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(bos.buffer()), "AoV");
            AoV.channel.sendTo(packet, player);
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void decodePacket(ByteBufInputStream stream) throws IOException {
        int index;
        int size = 0;
        size = stream.readInt();
        this.obtainedSkills.clear();
        for (index = 0; index < size; ++index) {
            this.obtainedSkills.add(AoVSkill.getSkillFromID(stream.readInt()));
        }
        this.skillPoints = stream.readInt();
        this.exp = stream.readInt();
        this.maxLevel = stream.readInt();
        this.invokeMass = stream.readBoolean();
        for (index = 0; index < 9; ++index) {
            this.slots[index] = stream.readBoolean() ? Ability.construct((IAoVCapability)this, stream) : null;
        }
        this.currentSlot = stream.readInt();
        this.dirty = true;
    }

    protected class DecayWrapper {
        private int amount;
        private int tick = 0;
        private int decayTick = 600;

        public DecayWrapper(int a) {
            this.amount = a;
        }

        public DecayWrapper() {
            this(1);
        }

        public void addDecay() {
            ++this.amount;
        }

        public void update() {
            ++this.tick;
            if (this.tick % this.decayTick == 0) {
                --this.amount;
            }
        }

        public int getDecay() {
            return this.amount;
        }
    }
}

