/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.capabilities.aov;

import Tamaized.AoV.capabilities.aov.AoVCapabilityHandler;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.core.skills.AoVSkill;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class AoVCapabilityStorage
implements Capability.IStorage<IAoVCapability> {
    public NBTBase writeNBT(Capability<IAoVCapability> capability, IAoVCapability instance, EnumFacing side) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (AoVSkill aoVSkill : instance.getObtainedSkills()) {
            list.func_74742_a((NBTBase)new NBTTagInt(aoVSkill.getID()));
        }
        nbt.func_74782_a("obtainedSkills", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry entry : instance.getDecayMap().entrySet()) {
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74768_a("id", AbilityBase.getID((AbilityBase)entry.getKey()));
            comp.func_74768_a("decay", ((AoVCapabilityHandler.DecayWrapper)entry.getValue()).getDecay());
            list.func_74742_a((NBTBase)comp);
        }
        nbt.func_74782_a("decay", (NBTBase)list);
        nbt.func_74768_a("skillPoints", instance.getSkillPoints());
        nbt.func_74768_a("exp", instance.getExp());
        nbt.func_74768_a("maxLevel", instance.getMaxLevel());
        nbt.func_74757_a("invokeMass", instance.getInvokeMass());
        list = new NBTTagList();
        for (int index = 0; index < 9; ++index) {
            Ability ability = instance.getSlot(index);
            NBTTagCompound ct = new NBTTagCompound();
            if (ability == null) {
                ct.func_74768_a("id", -1);
            } else {
                ability.encode(ct);
            }
            list.func_74742_a((NBTBase)ct);
        }
        nbt.func_74782_a("slots", (NBTBase)list);
        nbt.func_74768_a("currentSlot", instance.getCurrentSlot());
        return nbt;
    }

    public void readNBT(Capability<IAoVCapability> capability, IAoVCapability instance, EnumFacing side, NBTBase nbt) {
        int index;
        NBTTagCompound compound = (NBTTagCompound)nbt;
        NBTBase tag = compound.func_74781_a("obtainedSkills");
        if (tag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag;
            for (int index2 = 0; index2 < list.func_74745_c(); ++index2) {
                instance.addObtainedSkill(AoVSkill.getSkillFromID(list.func_186858_c(index2)));
            }
        }
        HashMap<AbilityBase, AoVCapabilityHandler.DecayWrapper> decay = new HashMap<AbilityBase, AoVCapabilityHandler.DecayWrapper>();
        tag = compound.func_74781_a("decay");
        if (tag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag;
            for (index = 0; index < list.func_74745_c(); ++index) {
                NBTTagCompound comp = list.func_150305_b(index);
                AbilityBase abilityBase = AbilityBase.getAbilityFromID(comp.func_74762_e("id"));
                AoVCapabilityHandler aoVCapabilityHandler = (AoVCapabilityHandler)instance;
                aoVCapabilityHandler.getClass();
                decay.put(abilityBase, aoVCapabilityHandler.new AoVCapabilityHandler.DecayWrapper(comp.func_74762_e("decay")));
            }
        }
        if (!decay.isEmpty()) {
            instance.setDecayMap(decay);
        }
        instance.setSkillPoints(compound.func_74762_e("skillPoints"));
        instance.setExp(compound.func_74762_e("exp"));
        instance.setMaxLevel(compound.func_74762_e("maxLevel"));
        instance.toggleInvokeMass(compound.func_74767_n("invokeMass"));
        instance.update(null);
        tag = compound.func_74781_a("slots");
        if (tag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag;
            for (index = 0; index < 9; ++index) {
                instance.setSlot(Ability.construct(instance, list.func_150305_b(index)), index);
            }
        }
        instance.setCurrentSlot(compound.func_74762_e("currentSlot"));
    }
}

