/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.config;

import Tamaized.AoV.AoV;
import java.io.IOException;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    private Configuration config;
    private int default_recharge = -1;
    private boolean default_experience = false;
    private int recharge = this.default_recharge;
    private boolean experience = this.default_experience;

    public ConfigHandler(Configuration c) {
        this.config = c;
        this.config.load();
        this.sync(true);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void sync(boolean firstLoad) {
        try {
            this.loadData(firstLoad);
            this.cleanupFile();
            this.config.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadData(boolean firstLoad) {
        this.recharge = this.config.get("general", "recharge", this.default_recharge, "Sets the recharge rate per second, -1 disables this").getInt();
        this.experience = this.config.get("general", "experience", this.default_experience, "Determines whether or not vanilla experience contributes to AoV experience gain").getBoolean();
    }

    private void cleanupFile() throws IOException {
        AoV.configFile.delete();
        AoV.configFile.createNewFile();
        this.config = new Configuration(AoV.configFile);
        this.config.get("general", "recharge", this.default_recharge, "Sets the recharge rate per second, -1 disables this").set(this.recharge);
        this.config.get("general", "experience", this.default_experience, "Determines whether or not vanilla experience contributes to AoV experience gain").set(this.experience);
    }

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("aov")) {
            this.sync(false);
        }
    }

    public int getRechargeRate() {
        return this.recharge;
    }

    public boolean getExperience() {
        return this.experience;
    }
}

