/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities;

import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.caster.BladeBarrier;
import Tamaized.AoV.core.abilities.caster.Destruction;
import Tamaized.AoV.core.abilities.caster.FlameStrike;
import Tamaized.AoV.core.abilities.caster.Implosion;
import Tamaized.AoV.core.abilities.caster.LeapOfFaith;
import Tamaized.AoV.core.abilities.caster.NimbusRay;
import Tamaized.AoV.core.abilities.caster.SearingLight;
import Tamaized.AoV.core.abilities.caster.SlayLiving;
import Tamaized.AoV.core.abilities.defender.Aid;
import Tamaized.AoV.core.abilities.defender.ShieldOfFaith;
import Tamaized.AoV.core.abilities.defender.StalwartPact;
import Tamaized.AoV.core.abilities.defender.Zeal;
import Tamaized.AoV.core.abilities.healer.Cores.Burst;
import Tamaized.AoV.core.abilities.healer.Cores.PosEnergyAura;
import Tamaized.AoV.core.abilities.healer.Cures.CureBlind;
import Tamaized.AoV.core.abilities.healer.Cures.CurePoison;
import Tamaized.AoV.core.abilities.healer.Cures.CureWither;
import Tamaized.AoV.core.abilities.healer.Healing.CureCriticalWounds;
import Tamaized.AoV.core.abilities.healer.Healing.CureLightWounds;
import Tamaized.AoV.core.abilities.healer.Healing.CureModWounds;
import Tamaized.AoV.core.abilities.healer.Healing.CureSeriousWounds;
import Tamaized.AoV.core.abilities.healer.Healing.Heal;
import Tamaized.AoV.core.abilities.universal.InvokeMass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public abstract class AbilityBase {
    private static final List<AbilityBase> registry = new ArrayList<AbilityBase>();
    public static final AbilityBase invokeMass = new InvokeMass();
    public static final AbilityBase cureLightWounds = new CureLightWounds();
    public static final AbilityBase cureModWounds = new CureModWounds();
    public static final AbilityBase cureSeriousWounds = new CureSeriousWounds();
    public static final AbilityBase cureCriticalWounds = new CureCriticalWounds();
    public static final AbilityBase heal = new Heal();
    public static final AbilityBase burst = new Burst();
    public static final AbilityBase posEnergyAura = new PosEnergyAura();
    public static final AbilityBase curePoison = new CurePoison();
    public static final AbilityBase cureWither = new CureWither();
    public static final AbilityBase cureBlind = new CureBlind();
    public static final AbilityBase nimbusRay = new NimbusRay();
    public static final AbilityBase searingLight = new SearingLight();
    public static final AbilityBase flameStrike = new FlameStrike();
    public static final AbilityBase leapOfFaith = new LeapOfFaith();
    public static final AbilityBase slayLiving = new SlayLiving();
    public static final AbilityBase destruction = new Destruction();
    public static final AbilityBase implosion = new Implosion();
    public static final AbilityBase bladeBarrier = new BladeBarrier();
    public static final AbilityBase aid = new Aid();
    public static final AbilityBase shieldOfFaith = new ShieldOfFaith();
    public static final AbilityBase zeal = new Zeal();
    public static final AbilityBase stalwartPact = new StalwartPact();
    public static final AbilityBase defenderBlocking = new NullAbility("DefenderBlocking");
    public static final AbilityBase defenderDodge = new NullAbility("DefenderDodge");
    public static final AbilityBase defenderDoublestrike = new NullAbility("DefenderDoublestrike");
    private final List<String> description = new ArrayList<String>();

    public static final int getID(AbilityBase skill) {
        return registry.contains(skill) ? registry.indexOf(skill) : -1;
    }

    public final int getID() {
        return AbilityBase.getID(this);
    }

    public static final AbilityBase getAbilityFromID(int id) {
        return id >= 0 && id < registry.size() ? registry.get(id) : null;
    }

    public AbilityBase(String ... desc) {
        for (String s : desc) {
            this.description.add(s);
        }
        registry.add(this);
    }

    public final List<String> getDescription() {
        return this.description;
    }

    public abstract String getName();

    public abstract int getMaxCharges();

    public abstract int getChargeCost();

    public abstract double getMaxDistance();

    public abstract int getCoolDown();

    public abstract boolean usesInvoke();

    public int getCost(IAoVCapability cap) {
        return this.usesInvoke() && cap.getInvokeMass() ? this.getChargeCost() * 2 : this.getChargeCost();
    }

    public abstract void cast(Ability var1, EntityPlayer var2, EntityLivingBase var3);

    public abstract ResourceLocation getIcon();

    private static final class NullAbility
    extends AbilityBase {
        private final String name;

        public NullAbility(String name) {
            super(new String[0]);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxCharges() {
            return 0;
        }

        @Override
        public int getChargeCost() {
            return 0;
        }

        @Override
        public double getMaxDistance() {
            return 0.0;
        }

        @Override
        public int getCoolDown() {
            return 0;
        }

        @Override
        public boolean usesInvoke() {
            return false;
        }

        @Override
        public void cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        }

        @Override
        public ResourceLocation getIcon() {
            return null;
        }
    }
}

