/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.caster;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.entity.EntitySpellBladeBarrier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class BladeBarrier
extends AbilityBase {
    private static final int damage = 5;
    private static final int charges = 5;
    private static final int distance = 4;

    public BladeBarrier() {
        super(TextFormatting.YELLOW + BladeBarrier.getStaticName(), "", TextFormatting.AQUA + "Charges: " + 5, TextFormatting.AQUA + "Range: " + 4, TextFormatting.AQUA + "Base Damage: " + 5, "", TextFormatting.DARK_PURPLE + "Summons a ring of spinning", TextFormatting.DARK_PURPLE + " blades to deal damage to", TextFormatting.DARK_PURPLE + " entities that enter or", TextFormatting.DARK_PURPLE + " exit the ring.");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/bladebarrier.png");
    }

    @Override
    public String getName() {
        return BladeBarrier.getStaticName();
    }

    public static String getStaticName() {
        return "Blade Barrier";
    }

    @Override
    public int getCoolDown() {
        return 8;
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 4.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public void cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        int a = (int)(5.0f * (1.0f + cap.getSpellPower() / 100.0f));
        caster.field_70170_p.func_72838_d((Entity)new EntitySpellBladeBarrier(caster.field_70170_p, (Entity)caster, a, 4));
    }
}

