/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.caster;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.entity.projectile.caster.ProjectileFlameStrike;
import Tamaized.AoV.sound.SoundEvents;
import Tamaized.TamModized.helper.RayTraceHelper;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class FlameStrike
extends AbilityBase {
    private static final int damage = 6;
    private static final int charges = 5;
    private static final int distance = 45;

    public FlameStrike() {
        super(TextFormatting.YELLOW + FlameStrike.getStaticName(), "", TextFormatting.AQUA + "Charges: " + 5, TextFormatting.AQUA + "Range: " + 45, TextFormatting.AQUA + "Base Damage: " + 6, "", TextFormatting.DARK_PURPLE + "Summons a ball of fire", TextFormatting.DARK_PURPLE + "to strike the ground", TextFormatting.DARK_PURPLE + "dealing damage to entities", TextFormatting.DARK_PURPLE + "around and setting them on fire");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/flamestrike.png");
    }

    @Override
    public String getName() {
        return FlameStrike.getStaticName();
    }

    public static String getStaticName() {
        return "Flame Strike";
    }

    @Override
    public int getCoolDown() {
        return 8;
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 45.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public void cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        int a = (int)(6.0f * (1.0f + cap.getSpellPower() / 100.0f));
        ProjectileFlameStrike strike = new ProjectileFlameStrike(caster.field_70170_p, (Entity)caster, a);
        HashSet<EntityPlayer> exclude = new HashSet<EntityPlayer>();
        exclude.add(caster);
        RayTraceResult result = RayTraceHelper.tracePath((World)caster.field_70170_p, (EntityPlayer)caster, (int)45, (float)1.0f, exclude);
        if (result != null && result.field_72313_a != null) {
            switch (result.field_72313_a) {
                case BLOCK: {
                    BlockPos pos = result.func_178782_a();
                    strike.func_70107_b(pos.func_177958_n(), pos.func_177956_o() + 15, pos.func_177952_p());
                    break;
                }
                case ENTITY: {
                    BlockPos pos = result.field_72308_g.func_180425_c();
                    strike.func_70107_b(pos.func_177958_n(), pos.func_177956_o() + 15, pos.func_177952_p());
                    break;
                }
                default: {
                    BlockPos pos = caster.func_180425_c();
                    strike.func_70107_b(pos.func_177958_n(), pos.func_177956_o() + 15, pos.func_177952_p());
                }
            }
        }
        caster.field_70170_p.func_72838_d((Entity)strike);
        strike.field_70170_p.func_184148_a(null, strike.field_70165_t, strike.field_70163_u - 20.0, strike.field_70161_v, SoundEvents.firestrike, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }
}

