/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.caster;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.entity.projectile.caster.ProjectileNimbusRay;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class NimbusRay
extends AbilityBase {
    private static final int damage = 4;
    private static final int charges = 6;
    private static final int distance = 20;

    public NimbusRay() {
        super(TextFormatting.YELLOW + NimbusRay.getStaticName(), "", TextFormatting.AQUA + "Charges: " + 6, TextFormatting.AQUA + "Range: " + 20, TextFormatting.AQUA + "Base Damage: " + 4, "", TextFormatting.DARK_PURPLE + "Shoots a small ray of light", TextFormatting.DARK_PURPLE + "to deal damage.", TextFormatting.DARK_PURPLE + "This damage is doubled on", TextFormatting.DARK_PURPLE + "Undead targets.");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/nimbus.png");
    }

    @Override
    public String getName() {
        return NimbusRay.getStaticName();
    }

    public static String getStaticName() {
        return "Nimbus Ray";
    }

    @Override
    public int getCoolDown() {
        return 2;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 20.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public void cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        int a = (int)(4.0f * (1.0f + cap.getSpellPower() / 100.0f));
        ProjectileNimbusRay ray = new ProjectileNimbusRay(caster.field_70170_p, caster, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
        ray.setSpell(this);
        ray.setColor(-39169);
        ray.func_70239_b(a);
        ray.setMaxRange(20);
        caster.field_70170_p.func_72838_d((Entity)ray);
    }
}

