/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.caster;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.registry.AoVDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class SlayLiving
extends AbilityBase {
    private static final int charges = 4;
    private static final int distance = 3;

    public SlayLiving() {
        super(TextFormatting.YELLOW + SlayLiving.getStaticName(), "", TextFormatting.AQUA + "Charges: " + 4, TextFormatting.AQUA + "Range: " + 3, "", TextFormatting.DARK_PURPLE + "Destroys a living target.", TextFormatting.DARK_PURPLE + "Does not affect Undead or", TextFormatting.DARK_PURPLE + "bosses.");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/slayliving.png");
    }

    @Override
    public String getName() {
        return SlayLiving.getStaticName();
    }

    public static String getStaticName() {
        return "Slay Living";
    }

    @Override
    public int getCoolDown() {
        return 6;
    }

    @Override
    public int getMaxCharges() {
        return 4;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 3.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public void cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        if (target == null) {
            return;
        }
        IAoVCapability cap = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (cap != null && !target.func_70662_br() && target.func_184222_aU()) {
            target.func_70097_a(AoVDamageSource.destruction, 2.1474836E9f);
            cap.addExp((Entity)caster, 20, AbilityBase.slayLiving);
        }
    }
}

