/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.defender;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.helper.ParticleHelper;
import Tamaized.AoV.registry.AoVPotions;
import Tamaized.AoV.sound.SoundEvents;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;

public class StalwartPact
extends AbilityBase {
    private static final String name = "Stalwart Pact";
    private static final int charges = 3;
    private static final double range = 3.0;

    public StalwartPact() {
        super(TextFormatting.YELLOW + name, "", TextFormatting.AQUA + "Charges: " + 3, TextFormatting.AQUA + "Range: " + 3.0, "", TextFormatting.DARK_PURPLE + "Upon reaching half or less health", TextFormatting.DARK_PURPLE + " you are granted with Absorption III", TextFormatting.DARK_PURPLE + " and Regeneration III, can be cast on", TextFormatting.DARK_PURPLE + " yourself or a target.");
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public double getMaxDistance() {
        return 3.0;
    }

    @Override
    public int getMaxCharges() {
        return 3;
    }

    @Override
    public boolean usesInvoke() {
        return true;
    }

    protected int getParticleColor() {
        return -1;
    }

    @Override
    public void cast(Ability ability, EntityPlayer player, EntityLivingBase e) {
        IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        if (cap.getInvokeMass()) {
            this.castAsMass((EntityLivingBase)player, cap);
        } else if (e == null) {
            this.addPotionEffects((EntityLivingBase)player);
        } else {
            if (cap.hasSelectiveFocus() && e instanceof IMob) {
                return;
            }
            this.addPotionEffects(e);
        }
        SoundEvents.playMovingSoundOnServer(SoundEvents.cast_2, (Entity)player);
        cap.addExp((Entity)player, 20, this);
    }

    private void addPotionEffects(EntityLivingBase entity) {
        entity.func_70690_d(new PotionEffect(AoVPotions.stalwartPact, 6000));
    }

    private void castAsMass(EntityLivingBase target, IAoVCapability cap) {
        int range = (int)(this.getMaxDistance() * 2.0);
        ParticleHelper.spawnParticleMesh(ParticleHelper.Type.BURST, target.field_70170_p, target.func_174791_d(), range, this.getParticleColor());
        List list = target.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(target.func_180425_c().func_177982_a(-range, -range, -range), target.func_180425_c().func_177982_a(range, range, range)));
        for (EntityLivingBase entity : list) {
            if (cap.hasSelectiveFocus() && entity instanceof IMob) continue;
            this.addPotionEffects(entity);
            cap.addExp((Entity)target, 20, this);
        }
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public int getCoolDown() {
        return 12;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/stalwart.png");
    }
}

