/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.defender;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.registry.AoVPotions;
import Tamaized.AoV.sound.SoundEvents;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class Zeal
extends AbilityBase {
    private static final String name = "Zeal";
    private static final int charges = 5;

    public Zeal() {
        super(TextFormatting.YELLOW + name, "", TextFormatting.AQUA + "Charges: " + 5, "", TextFormatting.DARK_PURPLE + "Grants +25 DoubleStrike", TextFormatting.DARK_PURPLE + " of yourself only.");
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public double getMaxDistance() {
        return 1.0;
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    protected int getParticleColor() {
        return -1;
    }

    @Override
    public void cast(Ability ability, EntityPlayer player, EntityLivingBase e) {
        IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        this.addPotionEffects((EntityLivingBase)player);
        SoundEvents.playMovingSoundOnServer(SoundEvents.cast_2, (Entity)player);
        cap.addExp((Entity)player, 20, this);
    }

    private void addPotionEffects(EntityLivingBase entity) {
        entity.func_70690_d(new PotionEffect(AoVPotions.zeal, 3000));
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public int getCoolDown() {
        return 12;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/zeal.png");
    }
}

