/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.healer.Cores;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.helper.ParticleHelper;
import Tamaized.AoV.sound.SoundEvents;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;

public class Burst
extends AbilityBase {
    private static final int charges = 6;
    private static final int range = 20;
    private static final int dmg = 10;

    public Burst() {
        super(TextFormatting.YELLOW + Burst.getStaticName(), "", TextFormatting.AQUA + "Charges: " + 6, TextFormatting.AQUA + "Range: " + 20, TextFormatting.AQUA + "Base Healing: " + 10, "", TextFormatting.DARK_PURPLE + "Heals everything around you,", TextFormatting.DARK_PURPLE + " including you, and cures", TextFormatting.DARK_PURPLE + " all harmful effects.", TextFormatting.DARK_PURPLE + " Deals damage to Undead.");
    }

    @Override
    public void cast(Ability ability, EntityPlayer player, EntityLivingBase e) {
        IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        ParticleHelper.spawnParticleMesh(ParticleHelper.Type.BURST, player.field_70170_p, player.func_174791_d(), 20, -65281);
        SoundEvents.playMovingSoundOnServer(SoundEvents.burst, (Entity)player);
        int a = (int)(10.0f * (1.0f + cap.getSpellPower() / 100.0f));
        List list = player.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(player.func_180425_c().func_177982_a(-20, -20, -20), player.func_180425_c().func_177982_a(20, 20, 20)));
        for (EntityLivingBase entity : list) {
            if (entity.func_70662_br()) {
                entity.func_70097_a(DamageSource.field_76376_m, (float)a);
            } else {
                if (cap.hasSelectiveFocus() && entity instanceof IMob) continue;
                entity.func_70691_i((float)a);
            }
            Iterator iter = entity.func_70651_bq().iterator();
            while (iter.hasNext()) {
                PotionEffect pot = (PotionEffect)iter.next();
                if (!pot.func_188419_a().func_76398_f()) continue;
                iter.remove();
            }
            cap.addExp((Entity)player, 20, this);
        }
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/burst.png");
    }

    @Override
    public String getName() {
        return Burst.getStaticName();
    }

    public static String getStaticName() {
        return "Positive Energy Burst";
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 20.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }
}

