/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.healer.Cores;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.core.abilities.IAura;
import Tamaized.AoV.helper.ParticleHelper;
import Tamaized.AoV.sound.SoundEvents;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;

public class PosEnergyAura
extends AbilityBase
implements IAura {
    private static final int charges = 6;
    private static final int range = 10;
    private static final int dmg = 2;
    private static final int life = 45;

    public PosEnergyAura() {
        super(TextFormatting.YELLOW + PosEnergyAura.getStaticName(), "", TextFormatting.AQUA + "Charges: " + 6, TextFormatting.AQUA + "Range: " + 10, TextFormatting.AQUA + "Base Healing: " + 2, TextFormatting.AQUA + "Lasts: " + 45 + " Seconds", "", TextFormatting.DARK_PURPLE + "Creates an aura around yourself", TextFormatting.DARK_PURPLE + "to heal you and everything", TextFormatting.DARK_PURPLE + "around you for a period of time.");
    }

    @Override
    public void cast(Ability ability, EntityPlayer player, EntityLivingBase e) {
        IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        cap.addAura(this.createAura(ability));
        SoundEvents.playMovingSoundOnServer(SoundEvents.aura, (Entity)player);
        cap.addExp((Entity)player, 20, this);
    }

    @Override
    public void castAsAura(EntityPlayer caster, IAoVCapability cap, int life) {
        int tick = 45 * 20 - life;
        if (tick > 0 && tick % 20 == 0) {
            ParticleHelper.spawnParticleMesh(ParticleHelper.Type.BURST, caster.field_70170_p, caster.func_174791_d(), 10, -65281);
            int a = (int)(2.0f * (1.0f + cap.getSpellPower() / 100.0f));
            List list = caster.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(caster.func_180425_c().func_177982_a(-10, -10, -10), caster.func_180425_c().func_177982_a(10, 10, 10)));
            for (EntityLivingBase entity : list) {
                if (entity.func_70662_br()) {
                    entity.func_70097_a(DamageSource.field_76376_m, (float)a);
                    continue;
                }
                if (cap.hasSelectiveFocus() && entity instanceof IMob) continue;
                entity.func_70691_i((float)a);
            }
        }
    }

    @Override
    public int getLife() {
        return 45;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/posaura.png");
    }

    @Override
    public String getName() {
        return PosEnergyAura.getStaticName();
    }

    public static String getStaticName() {
        return "Positive Energy Aura";
    }

    @Override
    public int getCoolDown() {
        return 60;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }
}

