/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.healer;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.helper.ParticleHelper;
import Tamaized.AoV.sound.SoundEvents;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;

public abstract class CureWounds
extends AbilityBase {
    private final String name;
    private final int damage;
    private final int charges;
    private final double range;

    public CureWounds(String n, int c, double r, int dmg) {
        super(TextFormatting.YELLOW + n, "", TextFormatting.AQUA + "Charges: " + c, TextFormatting.AQUA + "Range: " + r, TextFormatting.AQUA + "Base Healing: " + dmg, "", TextFormatting.DARK_PURPLE + "Heals yourself or an entity if", TextFormatting.DARK_PURPLE + "your crosshair is over the entity.");
        this.name = n;
        this.damage = dmg;
        this.charges = c;
        this.range = r;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getMaxDistance() {
        return this.range;
    }

    @Override
    public int getMaxCharges() {
        return this.charges;
    }

    @Override
    public boolean usesInvoke() {
        return true;
    }

    protected abstract int getParticleColor();

    @Override
    public void cast(Ability ability, EntityPlayer player, EntityLivingBase e) {
        IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        int a = (int)((float)this.damage * (1.0f + cap.getSpellPower() / 100.0f));
        if (cap.getInvokeMass()) {
            this.castAsMass((EntityLivingBase)player, a, cap);
        } else if (e == null) {
            player.func_70691_i((float)a);
            SoundEvents.playMovingSoundOnServer(SoundEvents.heal, (Entity)player);
        } else if (e.func_70662_br()) {
            e.func_70097_a(DamageSource.field_76376_m, (float)a);
            SoundEvents.playMovingSoundOnServer(SoundEvents.heal, (Entity)e);
        } else {
            if (cap.hasSelectiveFocus() && e instanceof IMob) {
                return;
            }
            e.func_70691_i((float)a);
            SoundEvents.playMovingSoundOnServer(SoundEvents.heal, (Entity)e);
        }
        cap.addExp((Entity)player, 20, this);
    }

    private void castAsMass(EntityLivingBase target, int dmg, IAoVCapability cap) {
        int range = (int)(this.getMaxDistance() * 2.0);
        ParticleHelper.spawnParticleMesh(ParticleHelper.Type.BURST, target.field_70170_p, target.func_174791_d(), range, this.getParticleColor());
        List list = target.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(target.func_180425_c().func_177982_a(-range, -range, -range), target.func_180425_c().func_177982_a(range, range, range)));
        for (EntityLivingBase entity : list) {
            if (entity.func_70662_br()) {
                entity.func_70097_a(DamageSource.field_76376_m, (float)dmg);
                SoundEvents.playMovingSoundOnServer(SoundEvents.heal, (Entity)entity);
            } else {
                if (cap.hasSelectiveFocus() && entity instanceof IMob) continue;
                entity.func_70691_i((float)dmg);
                SoundEvents.playMovingSoundOnServer(SoundEvents.heal, (Entity)entity);
            }
            cap.addExp((Entity)target, 20, this);
        }
    }
}

