/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.network;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.skills.AoVSkill;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ServerPacketHandler {
    public static int getPacketTypeID(PacketType type) {
        return type.ordinal();
    }

    public static PacketType getPacketTypeFromID(int id) {
        return id < PacketType.values().length ? PacketType.values()[id] : null;
    }

    @SubscribeEvent
    public void onServerPacket(final FMLNetworkEvent.ServerCustomPacketEvent event) {
        final EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        player.func_184102_h().func_152344_a(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerPacketHandler.processPacket(event.getPacket().payload(), Side.SERVER, player);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void processPacket(ByteBuf parBB, Side parSide, EntityPlayerMP player) throws IOException {
        if (parSide == Side.SERVER) {
            ByteBufInputStream bbis = new ByteBufInputStream(parBB);
            IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
            switch (ServerPacketHandler.getPacketTypeFromID(bbis.readInt())) {
                case CAST_SPELL: {
                    Ability ability;
                    int slot = bbis.readInt();
                    if (cap == null || (ability = cap.getSlot(slot)) == null) break;
                    ability.cast((EntityPlayer)player);
                    break;
                }
                case SKILLEDIT_CHECK_CANOBTAIN: {
                    AoVSkill skillToCheck;
                    if (cap == null || (skillToCheck = AoVSkill.getSkillFromID(bbis.readInt())) == null || skillToCheck.getParent() != null && !cap.hasSkill(skillToCheck.getParent()) || cap.getSkillPoints() < skillToCheck.getCost() || cap.getLevel() < skillToCheck.getLevel() || cap.getSpentSkillPoints() < skillToCheck.getSpentPoints()) break;
                    cap.addObtainedSkill(skillToCheck);
                    cap.setSkillPoints(cap.getSkillPoints() - skillToCheck.getCost());
                    break;
                }
                case RESETSKILLS_FULL: {
                    if (cap == null) break;
                    cap.reset(true);
                    break;
                }
                case RESETSKILLS_MINOR: {
                    if (cap == null) break;
                    cap.reset(false);
                    break;
                }
                case SPELLBAR_REMOVE: {
                    if (cap == null) break;
                    cap.removeSlot(bbis.readInt());
                    break;
                }
                case SPELLBAR_ADDNEAR: {
                    if (cap == null) break;
                    cap.addToNearestSlot(Ability.construct(cap, bbis));
                    break;
                }
                case CHARGES_RESET: {
                    if (cap == null) break;
                    cap.resetCharges();
                    break;
                }
            }
            bbis.close();
        }
    }

    public static enum PacketType {
        SKILLEDIT_CHECK_CANOBTAIN,
        RESETSKILLS_FULL,
        RESETSKILLS_MINOR,
        SPELLBAR_REMOVE,
        SPELLBAR_ADDNEAR,
        CHARGES_RESET,
        CAST_SPELL;

    }
}

