/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities;

import Tamaized.AoV.AoV;
import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.core.abilities.IAura;
import Tamaized.TamModized.helper.RayTraceHelper;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public final class Ability {
    private AbilityBase ability;
    private int cooldown;
    private int charges;
    private int decay;
    private int tick = 0;

    public Ability(AbilityBase ability, IAoVCapability cap) {
        this.ability = ability;
        this.reset(cap);
    }

    public static Ability construct(IAoVCapability cap, ByteBufInputStream stream) throws IOException {
        int id = stream.readInt();
        if (id < 0) {
            return null;
        }
        Ability ability = new Ability(AbilityBase.getAbilityFromID(id), cap);
        ability.decode(stream);
        return ability;
    }

    public static Ability construct(IAoVCapability cap, NBTTagCompound nbt) {
        int id = nbt.func_74762_e("id");
        if (id < 0) {
            return null;
        }
        Ability ability = new Ability(AbilityBase.getAbilityFromID(id), cap);
        ability.decode(nbt);
        return ability;
    }

    public void encode(DataOutputStream stream) throws IOException {
        stream.writeInt(this.ability.getID());
        stream.writeInt(this.cooldown);
        stream.writeInt(this.charges);
        stream.writeInt(this.decay);
    }

    public void decode(ByteBufInputStream stream) throws IOException {
        this.cooldown = stream.readInt();
        this.charges = stream.readInt();
        this.decay = stream.readInt();
    }

    public NBTTagCompound encode(NBTTagCompound nbt) {
        nbt.func_74768_a("id", this.ability.getID());
        nbt.func_74768_a("cooldown", this.cooldown);
        nbt.func_74768_a("charges", this.charges);
        nbt.func_74768_a("decay", this.decay);
        return nbt;
    }

    public void decode(NBTTagCompound nbt) {
        this.cooldown = nbt.func_74762_e("cooldown");
        this.charges = nbt.func_74762_e("charges");
        this.decay = nbt.func_74762_e("decay");
    }

    public void reset(IAoVCapability cap) {
        this.cooldown = 0;
        this.charges = this.ability.getMaxCharges() < 0 ? -1 : this.ability.getMaxCharges() + cap.getExtraCharges();
        this.decay = 0;
    }

    public final void cast(EntityPlayer caster) {
        HashSet<EntityPlayer> set = new HashSet<EntityPlayer>();
        set.add(caster);
        RayTraceResult ray = RayTraceHelper.tracePath((World)caster.field_70170_p, (EntityPlayer)caster, (int)((int)this.getAbility().getMaxDistance()), (float)1.0f, set);
        this.cast(caster, ray == null || ray.field_72308_g == null || !(ray.field_72308_g instanceof EntityLivingBase) ? null : (EntityLivingBase)ray.field_72308_g);
    }

    public void cast(EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (cap != null && cap.canUseAbility(this)) {
            this.ability.cast(this, caster, target);
            this.charges -= this.ability.getCost(cap);
            this.cooldown = this.ability.getCoolDown() * (this.ability.usesInvoke() && cap.getInvokeMass() ? 2 : 1);
        }
    }

    public void castAsAura(EntityPlayer caster, IAoVCapability cap, int life) {
        if (this.ability instanceof IAura) {
            ((IAura)((Object)this.ability)).castAsAura(caster, cap, life);
        }
    }

    public boolean canUse(IAoVCapability cap) {
        return this.cooldown <= 0 && (this.charges == -1 || this.charges >= this.ability.getCost(cap)) && cap.slotsContain(this);
    }

    public AbilityBase getAbility() {
        return this.ability;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public float getCooldownPerc() {
        return (float)this.cooldown / (float)this.ability.getCoolDown();
    }

    public int getCharges() {
        return this.charges;
    }

    public int getDecay() {
        return this.decay;
    }

    public void update(IAoVCapability cap) {
        ++this.tick;
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.decay > 0 && this.tick % 20 == 0) {
            --this.decay;
        }
        if (this.ability.getMaxCharges() >= 0 && AoV.config.getRechargeRate() >= 0 && this.charges < this.ability.getMaxCharges() + cap.getExtraCharges() && this.tick % AoV.config.getRechargeRate() == 0) {
            ++this.charges;
        }
    }

    public boolean compare(Ability check) {
        return check != null && this.ability == check.ability;
    }
}

