/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.core.abilities.caster;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.Ability;
import Tamaized.AoV.core.abilities.AbilityBase;
import Tamaized.AoV.entity.projectile.caster.ProjectileNimbusRay;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class SearingLight
extends AbilityBase {
    private static final int damage = 8;
    private static final int charges = 6;
    private static final int distance = 40;

    public SearingLight() {
        super(TextFormatting.YELLOW + SearingLight.getStaticName(), "", TextFormatting.AQUA + "Charges: " + 6, TextFormatting.AQUA + "Range: " + 40, TextFormatting.AQUA + "Base Damage: " + 8, "", TextFormatting.DARK_PURPLE + "Shoots a ray searing of light", TextFormatting.DARK_PURPLE + "to deal damage.", TextFormatting.DARK_PURPLE + "This damage is doubled on", TextFormatting.DARK_PURPLE + "Undead targets.");
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/searing.png");
    }

    @Override
    public String getName() {
        return SearingLight.getStaticName();
    }

    public static String getStaticName() {
        return "Searing Light";
    }

    @Override
    public int getCoolDown() {
        return 4;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 40.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public void cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)caster.getCapability(CapabilityList.AOV, null);
        if (cap == null) {
            return;
        }
        int a = (int)(8.0f * (1.0f + cap.getSpellPower() / 100.0f));
        ProjectileNimbusRay ray = new ProjectileNimbusRay(caster.field_70170_p, caster, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
        ray.setSpell(this);
        ray.setColor(-1);
        ray.func_70239_b(a);
        ray.setMaxRange(40);
        ray.setSpeed(3);
        caster.field_70170_p.func_72838_d((Entity)ray);
    }
}

