/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.entity;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.core.abilities.AbilityBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntitySpellBladeBarrier
extends Entity
implements IEntityAdditionalSpawnData {
    private Entity caster;
    private int life = 600;
    private int tick = this.life + 1;
    private float damage = 1.0f;
    private int range = 10;
    private List<EntityLivingBase> entityList = new ArrayList<EntityLivingBase>();

    public EntitySpellBladeBarrier(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
    }

    public EntitySpellBladeBarrier(World world, Entity entity, float dmg, int r) {
        this(world);
        this.caster = entity;
        this.damage = dmg;
        this.range = r;
        this.func_70634_a(this.caster.field_70165_t, this.caster.field_70163_u, this.caster.field_70161_v);
        this.tick = 0;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.tick);
        buffer.writeInt(this.range);
    }

    public void readSpawnData(ByteBuf data) {
        this.tick = data.readInt();
        this.range = data.readInt();
    }

    public int getRange() {
        return this.range;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.caster == null || !this.caster.func_70089_S() || this.tick >= this.life) {
            this.func_70106_y();
            return;
        }
        List list = this.field_70170_p.func_72839_b(this.caster, new AxisAlignedBB(this.func_180425_c().func_177982_a(-this.range, -2, -this.range), this.func_180425_c().func_177982_a(this.range, 2, this.range)));
        Iterator<EntityLivingBase> iter = this.entityList.iterator();
        while (iter.hasNext()) {
            EntityLivingBase e = iter.next();
            if (list.contains(e)) continue;
            this.doDamage(e);
            iter.remove();
        }
        for (Entity e : list) {
            if (!(e instanceof EntityLivingBase) || this.entityList.contains(e)) continue;
            this.doDamage((EntityLivingBase)e);
            this.entityList.add((EntityLivingBase)e);
        }
        ++this.tick;
    }

    private void doDamage(EntityLivingBase e) {
        e.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), this.damage);
        if (this.caster.hasCapability(CapabilityList.AOV, null)) {
            ((IAoVCapability)this.caster.getCapability(CapabilityList.AOV, null)).addExp(this.caster, 20, AbilityBase.bladeBarrier);
        }
    }
}

