/*
 * Decompiled with CFR 0.152.
 */
package Tamaized.AoV.network;

import Tamaized.AoV.capabilities.CapabilityList;
import Tamaized.AoV.capabilities.aov.IAoVCapability;
import Tamaized.AoV.sound.EntityMovingSound;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientPacketHandler {
    public static int getPacketTypeID(PacketType type) {
        return type.ordinal();
    }

    public static PacketType getPacketTypeFromID(int id) {
        return id < PacketType.values().length ? PacketType.values()[id] : null;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientPacket(final FMLNetworkEvent.ClientCustomPacketEvent event) {
        Minecraft.func_71410_x().func_152344_a(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientPacketHandler.processPacket(event.getPacket().payload(), Side.CLIENT);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static void processPacket(ByteBuf parBB, Side parSide) throws IOException {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        ByteBufInputStream bbis = new ByteBufInputStream(parBB);
        int pktType = bbis.readInt();
        switch (ClientPacketHandler.getPacketTypeFromID(pktType)) {
            case MovingSound: {
                Entity entity = world.func_73045_a(bbis.readInt());
                if (entity == null) break;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new EntityMovingSound((SoundEvent)SoundEvent.field_187505_a.func_148754_a(bbis.readInt()), SoundCategory.PLAYERS, entity, false, 0));
                break;
            }
            case AOVDATA: {
                IAoVCapability cap;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player == null || (cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null)) == null) break;
                cap.decodePacket(bbis);
                break;
            }
        }
        bbis.close();
    }

    public static enum PacketType {
        AOVDATA,
        MovingSound;

    }
}

