/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.entity;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import tamaized.aov.common.config.ConfigHandler;
import tamaized.aov.common.entity.EntityEarthquake;

public class RenderEarthquake
extends Render<EntityEarthquake> {
    private static final ResourceLocation SHADOW_TEXTURES = new ResourceLocation("textures/misc/shadow.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("aov", "textures/entity/earthquake.png");

    public RenderEarthquake(RenderManager renderManager) {
        super(renderManager);
    }

    private static void renderShadow(Entity entityIn, double x, double y, double z, float shadowAlpha, float partialTicks) {
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(SHADOW_TEXTURES);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        GlStateManager.func_179132_a((boolean)false);
        float f = 3.0f;
        if (entityIn instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entityIn;
            f *= entityliving.func_70603_bj();
            if (entityliving.func_70631_g_()) {
                f *= 0.5f;
            }
        }
        double d5 = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        double d0 = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        double d1 = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        int i = MathHelper.func_76128_c((double)(d5 - (double)f));
        int j = MathHelper.func_76128_c((double)(d5 + (double)f));
        int k = MathHelper.func_76128_c((double)(d0 - (double)f));
        int l = MathHelper.func_76128_c((double)d0);
        int i1 = MathHelper.func_76128_c((double)(d1 - (double)f));
        int j1 = MathHelper.func_76128_c((double)(d1 + (double)f));
        double d2 = x - d5;
        double d3 = y - d0;
        double d4 = z - d1;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)new BlockPos(i, l, i1), (BlockPos)new BlockPos(j, l, j1))) {
            IBlockState iblockstate = world.func_180495_p(blockpos.func_177977_b());
            if (iblockstate.func_185901_i() == EnumBlockRenderType.INVISIBLE || world.func_175671_l(blockpos) <= 3) continue;
            RenderEarthquake.renderShadowSingle(iblockstate, x, y, z, blockpos, shadowAlpha, f, d2, d3, d4);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
    }

    private static void renderShadowSingle(IBlockState state, double p_188299_2_, double p_188299_4_, double p_188299_6_, BlockPos p_188299_8_, float p_188299_9_, float p_188299_10_, double p_188299_11_, double p_188299_13_, double p_188299_15_) {
        if (state.func_185917_h()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            double d0 = ((double)p_188299_9_ - (p_188299_4_ - ((double)p_188299_8_.func_177956_o() + p_188299_13_)) / 2.0) * 0.5 * (double)Minecraft.func_71410_x().field_71441_e.func_175724_o(p_188299_8_);
            if (d0 >= 0.0) {
                if (d0 > 1.0) {
                    d0 = 1.0;
                }
                AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)Minecraft.func_71410_x().field_71441_e, p_188299_8_);
                double d1 = (double)p_188299_8_.func_177958_n() + axisalignedbb.field_72340_a + p_188299_11_;
                double d2 = (double)p_188299_8_.func_177958_n() + axisalignedbb.field_72336_d + p_188299_11_;
                double d3 = (double)p_188299_8_.func_177956_o() + axisalignedbb.field_72338_b + p_188299_13_ + 0.015625;
                double d4 = (double)p_188299_8_.func_177952_p() + axisalignedbb.field_72339_c + p_188299_15_;
                double d5 = (double)p_188299_8_.func_177952_p() + axisalignedbb.field_72334_f + p_188299_15_;
                float f = (float)((p_188299_2_ - d1) / 2.0 / (double)p_188299_10_ + 0.5);
                float f1 = (float)((p_188299_2_ - d2) / 2.0 / (double)p_188299_10_ + 0.5);
                float f2 = (float)((p_188299_6_ - d4) / 2.0 / (double)p_188299_10_ + 0.5);
                float f3 = (float)((p_188299_6_ - d5) / 2.0 / (double)p_188299_10_ + 0.5);
                bufferbuilder.func_181662_b(d1, d3, d4).func_187315_a((double)f, (double)f2).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d1, d3, d5).func_187315_a((double)f, (double)f3).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d2, d3, d5).func_187315_a((double)f1, (double)f3).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
                bufferbuilder.func_181662_b(d2, d3, d4).func_187315_a((double)f1, (double)f2).func_181666_a(1.0f, 1.0f, 1.0f, (float)d0).func_181675_d();
            }
        }
    }

    public void doRender(@Nonnull EntityEarthquake entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        this.renderMask(entity, x, y, z, partialTicks);
        this.renderQuakes(entity, x, y, z, partialTicks);
    }

    private void renderMask(@Nonnull EntityEarthquake entity, double x, double y, double z, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GL11.glEnable((int)2960);
        GL11.glStencilMask((int)255);
        GL11.glStencilFunc((int)519, (int)(ConfigHandler.stencil + 6), (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        RenderEarthquake.renderShadow(entity, x, y, z, 1.0f, partialTicks);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilMask((int)0);
        GL11.glDisable((int)2960);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
    }

    private void renderQuakes(@Nonnull EntityEarthquake entity, double x, double y, double z, float partialTicks) {
        GL11.glEnable((int)2960);
        GL11.glStencilFunc((int)514, (int)(ConfigHandler.stencil + 6), (int)255);
        this.func_110776_a(TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        AtomicReference<Float> offset = new AtomicReference<Float>(Float.valueOf(0.0f));
        entity.quakes.removeIf(q -> q.render(entity, x, y + (double)((Float)offset.updateAndGet(v -> Float.valueOf(v.floatValue() + 1.0E-4f))).floatValue(), z, partialTicks));
        GL11.glStencilMask((int)0);
        GL11.glDisable((int)2960);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityEarthquake entity) {
        return TEXTURE;
    }
}

