/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.glu.Sphere;
import tamaized.aov.common.entity.EntityGravity;

public class RenderGravity<T extends EntityGravity>
extends Render<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("aov", "textures/entity/gravity.png");
    public static final Sphere SPHERE = new Sphere();

    public RenderGravity(RenderManager renderManager) {
        super(renderManager);
    }

    public static void renderSphere(float radius) {
        SPHERE.setDrawStyle(100012);
        SPHERE.setNormals(100000);
        SPHERE.setOrientation(100020);
        SPHERE.draw(radius, 32, 32);
    }

    public static void drawBoltSegment(Tessellator tessellator, Vec3d p1, Vec3d p2, float scale, int color) {
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)p1.field_72450_a, (double)p1.field_72448_b, (double)p1.field_72449_c);
        double dist = p1.func_72438_d(p2);
        float xd = (float)(p1.field_72450_a - p2.field_72450_a);
        float yd = (float)(p1.field_72448_b - p2.field_72448_b);
        float zd = (float)(p1.field_72449_c - p2.field_72449_c);
        double var7 = MathHelper.func_76133_a((double)(xd * xd + zd * zd));
        float rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        float rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + rotYaw), (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179129_p();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i <= 9; ++i) {
            float f = ((float)i + 1.0f) / 9.0f;
            float verX = MathHelper.func_76126_a((float)((float)(i % 3) * (float)Math.PI * 2.0f / 3.0f)) * f * scale;
            float verZ = MathHelper.func_76134_b((float)((float)(i % 3) * (float)Math.PI * 2.0f / 3.0f)) * f * scale;
            float r = (float)(color >> 24 & 0xFF) / 255.0f;
            float g = (float)(color >> 16 & 0xFF) / 255.0f;
            float b = (float)(color >> 8 & 0xFF) / 255.0f;
            float a = (float)(color & 0xFF) / 255.0f;
            buffer.func_181662_b((double)verX, dist, (double)verZ).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)verX, 0.0, (double)verZ).func_181666_a(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public static void renderBoltBetween(Vec3d point1, Vec3d point2, double scale, double maxDeflection, int maxSegments, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        Random random = new Random();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        double distance = point1.func_72438_d(point2);
        Vec3d dirVec = new Vec3d(point2.field_72450_a - point1.field_72450_a, point2.field_72448_b - point1.field_72448_b, point2.field_72449_c - point1.field_72449_c);
        Vec3d invDir = new Vec3d(1.0, 1.0, 1.0).func_178788_d(dirVec);
        Vec3d[] vectors = new Vec3d[maxSegments / 2 + random.nextInt(maxSegments / 2)];
        vectors[0] = point1;
        vectors[vectors.length - 1] = point2;
        for (int i = 1; i < vectors.length - 1; ++i) {
            double pos = (double)i / (double)vectors.length * distance;
            Vec3d point = new Vec3d(point1.field_72450_a, point1.field_72448_b, point1.field_72449_c);
            point = point.func_178787_e(new Vec3d(dirVec.field_72450_a, dirVec.field_72448_b, dirVec.field_72449_c).func_186678_a(pos));
            double randX = (-0.5 + random.nextDouble()) * maxDeflection * invDir.field_72450_a;
            double randY = (-0.5 + random.nextDouble()) * maxDeflection * invDir.field_72448_b;
            double randZ = (-0.5 + random.nextDouble()) * maxDeflection * invDir.field_72449_c;
            vectors[i] = point = point.func_72441_c(randX, randY, randZ);
        }
        double rScale = scale * (0.5 + random.nextDouble() * 0.5);
        for (int i = 1; i < vectors.length; ++i) {
            RenderGravity.drawBoltSegment(tessellator, vectors[i - 1], vectors[i], (float)rScale, color);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    public void doRender(@Nonnull T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        float alpha = ((EntityGravity)((Object)entity)).spinnyBoi >= 600.0f ? (((EntityGravity)((Object)entity)).spinnyBoi - 600.0f) / 420.0f : 0.0f;
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)(1.0f - alpha));
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 5.0), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float s = Math.min(((EntityGravity)((Object)entity)).spinnyBoi / 180.0f, 1.0f);
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_ALPHA);
        GlStateManager.func_179094_E();
        this.func_110776_a(TEXTURE);
        SPHERE.setTextureFlag(true);
        ((EntityGravity)((Object)entity)).spinnyBoi = ((EntityGravity)((Object)entity)).spinnyBoi + (Minecraft.func_71410_x().func_147113_T() ? 0.0f : 360.0f / (float)Minecraft.func_175610_ah());
        GlStateManager.func_179114_b((float)(((EntityGravity)((Object)entity)).spinnyBoi % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderGravity.renderSphere(4.0f);
        GlStateManager.func_179131_c((float)0.5f, (float)0.75f, (float)0.75f, (float)(1.0f - alpha));
        RenderGravity.renderSphere(1.0f);
        GlStateManager.func_179114_b((float)(-((EntityGravity)((Object)entity)).spinnyBoi % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        float scale = 0.25f;
        for (int i = 0; i <= 8; ++i) {
            Vec3d rot = new Vec3d(0.75, (double)2.35f, 0.0).func_178789_a((float)i * 30.0f % 360.0f).func_178785_b((float)i * 30.0f % 360.0f);
            rot.func_72441_c((double)((float)i / 4.0f - 1.0f), 0.0, (double)((float)i / 4.0f - 1.0f));
            RenderGravity.renderBoltBetween(rot, new Vec3d(-rot.field_72450_a * (double)scale, -rot.field_72448_b * (double)scale, -rot.field_72449_c * (double)scale), 0.015f, 0.5, 6, 2007695136);
        }
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(@Nonnull T entity) {
        return TEXTURE;
    }
}

