/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAir;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import tamaized.aov.common.capabilities.aov.IAoVCapability;

@Mod.EventBusSubscriber
@Config(modid="aov")
public class ConfigHandler {
    @Config.Name(value="Element Positions")
    @Config.Comment(value={"The XY positions of on screen elements from the mod"})
    public static ElementPositions elementPositions = new ElementPositions();
    @Config.Name(value="Earthquake")
    @Config.Comment(value={"Manages the Earthquake Spell Block Destruction"})
    public static Earthquake earthquake = new Earthquake();
    @Config.Name(value="Max Level")
    @Config.Comment(value={"Sets the maximum level"})
    public static int maxlevel = 15;
    @Config.Name(value="Speedy Handwraps")
    @Config.Comment(value={"Handwraps add +6 to base attack speed"})
    public static boolean handwrapsSpeed = true;
    @Config.Name(value="Recharge Delay")
    @Config.Comment(value={"Sets the recharge rate per tick, -1 disables this"})
    public static int recharge = -1;
    @Config.Name(value="Enable Vanilla Experience gain")
    @Config.Comment(value={"Determines whether or not vanilla experience contributes to AoV experience gain"})
    public static boolean experience = false;
    @Config.Name(value="Render SpellBar Over HotBar")
    @Config.Comment(value={"Sets the Spellbar to render in place of the hotbar while active."})
    public static boolean renderBarOverHotbar = false;
    @Config.Name(value="Render Charges Above SpellBar")
    @Config.Comment(value={"Renders the Charges left to be above the Spellbar instead of below. This setting has no impact if Render SpellBar Over HotBar is enabled."})
    public static boolean renderChargesAboveSpellbar = false;
    @Config.Name(value="Render Astro UI while Empty")
    @Config.Comment(value={"If false, the Astro UI will no longer render while not holding any card, spread, or royal road buff."})
    public static boolean renderAstro = true;
    @Config.Name(value="Render Royal Road Text")
    @Config.Comment(value={"Enables the text render for the Astro UI Royal Road. If disabled, only the icon will render."})
    public static boolean renderRoyalRoad = true;
    @Config.Name(value="Render Target UI")
    @Config.Comment(value={"Enables the targetting UI renderer."})
    public static boolean renderTarget = true;
    @Config.Name(value="Target UI Opcaity")
    @Config.Comment(value={"How transparent the target ui is."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static float targetOpacity = 0.25f;
    @Config.Name(value="Starting Stencil Buffer ref Value")
    @Config.Comment(value={"Increase this if you experience weird render issues with this mod and other mods."})
    @Config.RangeInt(min=0)
    public static int stencil = 100;
    @Config.Name(value="Centered Wear")
    @Config.Comment(value={"domain:name:meta\ndomain defaults to `minecraft`\nmeta is optional\ndomain is required if meta is specified"})
    public static String[] centered = new String[]{"aov:handwraps", ConfigHandler.getRegName(Items.field_151041_m), ConfigHandler.getRegName(Items.field_151053_p), ConfigHandler.getRegName(Items.field_151017_I), ConfigHandler.getRegName(Items.field_151039_o), ConfigHandler.getRegName(Items.field_151038_n), ConfigHandler.getRegName((Item)Items.field_151021_T), ConfigHandler.getRegName((Item)Items.field_151027_R), ConfigHandler.getRegName((Item)Items.field_151024_Q), ConfigHandler.getRegName((Item)Items.field_151026_S)};
    @Config.Ignore
    public static Set<IAoVCapability.ItemStackWrapper> CENTERED_WEAR = ImmutableSet.of();

    private static String getRegName(Item item) {
        return Objects.requireNonNull(item.getRegistryName()).func_110623_a();
    }

    public static void setupCenteredWear() {
        ArrayList list = Lists.newArrayList();
        for (String next : centered) {
            Item item;
            String[] split = next.split(":");
            String domain = "minecraft";
            String regname = split[0];
            int meta = 0;
            boolean hasmeta = false;
            if (split.length > 1) {
                domain = split[0];
                regname = split[1];
                if (split.length > 2) {
                    try {
                        meta = Integer.parseInt(split[2]);
                        hasmeta = true;
                    }
                    catch (NumberFormatException e) {
                        hasmeta = false;
                    }
                }
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(domain, regname))) == null || item instanceof ItemAir) continue;
            list.add(hasmeta ? new IAoVCapability.ItemStackWrapper(item, meta) : new IAoVCapability.ItemStackWrapper(item));
        }
        CENTERED_WEAR = ImmutableSet.copyOf((Collection)list);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("aov")) {
            ConfigManager.sync((String)"aov", (Config.Type)Config.Type.INSTANCE);
            ConfigHandler.setupCenteredWear();
        }
    }

    public static class Earthquake {
        @Config.Name(value="Enable")
        public boolean enable = true;
        @Config.Name(value="Enable Screen Shaking")
        public boolean shake = true;
        @Config.Name(value="Enable Air")
        @Config.Comment(value={"If Disabled, destruction stops at the last block rather than setting to air"})
        public boolean air = true;
        @Config.Name(value="Destruction Ticks")
        @Config.Comment(value={"Amount of Ticks to wait until the next Destruction; Lower = Sooner"})
        @Config.RangeInt(min=1)
        public int ticks = 5;
        @Config.Name(value="Destruction Chance")
        @Config.Comment(value={"Chance that a Destruction will take place; Lower = Higher Chance"})
        @Config.RangeInt(min=1)
        public int chance = 5;
        @Config.Name(value="Destruction Order")
        @Config.Comment(value={"domain:name:meta|other\nmeta is optional\n[other] is what CAN be broken down but won't be broken down into.\n\nExample: [minecraft:gravel|minecraft:grass] may have Cobble before it, so Cobble breaks down into Gravel, which may have Dirt after it so Gravel breaks down into Dirt.\nGrass will also break down into Dirt but Cobble will never break down into Grass."})
        public String[] destruction = new String[]{"minecraft:stone", "minecraft:cobblestone", "minecraft:gravel|minecraft:grass", "minecraft:dirt", "minecraft:sand"};
    }

    public static class ElementPositions {
        @Config.Name(value="SpellBar X")
        public int spellbar_x = 0;
        @Config.Name(value="SpellBar Y")
        public int spellbar_y = 0;
        @Config.Name(value="Astro X")
        public int astro_x = 0;
        @Config.Name(value="Astro Y")
        public int astro_y = 0;
        @Config.Name(value="Target X")
        public int target_x = 0;
        @Config.Name(value="Target Y")
        public int target_y = 0;
    }
}

