/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.IAura;
import tamaized.aov.registry.AoVParticles;
import tamaized.aov.registry.ParticleRegistry;
import tamaized.aov.registry.SoundEvents;
import tamaized.tammodized.common.helper.CapabilityHelper;
import tamaized.tammodized.common.particles.ParticleHelper;

public class ElementalEmpowerment
extends AbilityBase
implements IAura {
    private static final String UNLOC = "aov.spells.elementalempowerment";
    private static final float DAMAGE = 1.0f;
    private static final float RANGE = 4.0f;
    private static final int CHARGES = 2;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/elementalempowerment.png");

    public ElementalEmpowerment() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{2}), new TextComponentTranslation("aov.spells.global.range", new Object[]{Float.valueOf(4.0f)}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{Float.valueOf(1.0f)}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 2;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 4.0;
    }

    @Override
    public int getCoolDown() {
        return 90;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean shouldDisable(@Nullable EntityPlayer caster, IAoVCapability cap) {
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        return poly == null || poly.getMorph() != IPolymorphCapability.Morph.FireElemental && poly.getMorph() != IPolymorphCapability.Morph.WaterElemental;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.AOV, null);
        if (cap == null) {
            return false;
        }
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        if (poly != null) {
            switch (poly.getMorph()) {
                case WaterElemental: 
                case FireElemental: {
                    cap.addAura(this.createAura(ability));
                    SoundEvents.playMovingSoundOnServer(SoundEvents.aura, (Entity)caster);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public void castAsAura(EntityPlayer caster, IAoVCapability cap, int life) {
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        if (poly != null) {
            switch (poly.getMorph()) {
                case WaterElemental: {
                    ParticleRegistry.spawnFromServer(caster.field_70170_p, AoVParticles.SNOW, caster.field_70165_t + caster.field_70170_p.field_73012_v.nextDouble() * 1.5 - 0.75, caster.field_70163_u + (double)caster.eyeHeight - 0.25 + caster.field_70170_p.field_73012_v.nextDouble() * 1.5 - 0.75, caster.field_70161_v + caster.field_70170_p.field_73012_v.nextDouble() * 1.5 - 0.75, 0.0, -0.03f, 0.0, new int[0]);
                    break;
                }
                case FireElemental: {
                    ParticleHelper.spawnVanillaParticleOnServer((World)caster.field_70170_p, (EnumParticleTypes)EnumParticleTypes.FLAME, (double)(caster.field_70165_t + caster.field_70170_p.field_73012_v.nextDouble() * 1.5 - 0.75), (double)(caster.field_70163_u + (double)caster.eyeHeight - 0.25 + caster.field_70170_p.field_73012_v.nextDouble() * 1.5 - 0.75), (double)(caster.field_70161_v + caster.field_70170_p.field_73012_v.nextDouble() * 1.5 - 0.75), (double)0.0, (double)0.0, (double)0.0);
                    float damage = 1.0f * (1.0f + cap.getSpellPower() / 100.0f);
                    if (life <= 0 || life % 60 != 0) break;
                    List list = caster.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(caster.func_180425_c().func_177963_a(-4.0, -4.0, -4.0), caster.func_180425_c().func_177963_a(4.0, 4.0, 4.0)));
                    for (EntityLivingBase entity : list) {
                        if (!IAoVCapability.selectiveTarget((Entity)caster, cap, entity) || !entity.func_70097_a(DamageSource.field_76372_a, damage)) continue;
                        entity.func_70015_d(5);
                        cap.addExp((Entity)caster, 20, this);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public int getLife() {
        return 45;
    }
}

