/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.tammodized.common.helper.CapabilityHelper;
import tamaized.tammodized.common.helper.RayTraceHelper;

public class FuriousClaw
extends AbilityBase {
    public static final byte BIT = 8;
    private static final int CHARGES = 10;
    public static final float DAMAGE = 2.0f;
    private static final String UNLOC = "aov.spells.furiousclaw";
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/furiousclaw.png");

    public FuriousClaw() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{10}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{Float.valueOf(2.0f)}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    public static boolean invoke(byte bit, EntityPlayer caster, AbilityBase ability) {
        IPolymorphCapability cap = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        if (cap == null || cap.getMorph() != IPolymorphCapability.Morph.Wolf) {
            return false;
        }
        if (caster.field_70170_p.field_72995_K) {
            caster.func_184609_a(EnumHand.MAIN_HAND);
        }
        cap.addFlagBits(bit);
        RayTraceResult ray = RayTraceHelper.tracePath((World)caster.field_70170_p, (EntityPlayer)caster, (int)((int)caster.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e()), (float)1.0f, (HashSet)Sets.newHashSet((Object[])new Entity[]{caster}));
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.ENTITY) {
            caster.func_71059_n(ray.field_72308_g);
            IAoVCapability aov = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.AOV, null);
            if (aov != null) {
                aov.addExp((Entity)caster, 20, ability);
            }
        }
        cap.subtractFlagBits(bit);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 10;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public int getExtraCharges(EntityLivingBase entity, IAoVCapability cap) {
        return IAoVCapability.isImprovedCentered(entity, cap) ? this.getMaxCharges() : super.getExtraCharges(entity, cap);
    }

    @Override
    public double getMaxDistance() {
        return 0.0;
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean shouldDisable(@Nullable EntityPlayer caster, IAoVCapability cap) {
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        return poly == null || poly.getMorph() != IPolymorphCapability.Morph.Wolf;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        return FuriousClaw.invoke((byte)8, caster, this);
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public boolean runOnClient() {
        return true;
    }
}

