/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.druid.FuriousClaw;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class FuriousFang
extends AbilityBase {
    public static final byte BIT = 4;
    private static final int CHARGES = 5;
    public static final float DAMAGE = 4.0f;
    private static final String UNLOC = "aov.spells.furiousfang";
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/furiousfang.png");

    public FuriousFang() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{5}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{Float.valueOf(4.0f)}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public int getExtraCharges(EntityLivingBase entity, IAoVCapability cap) {
        return IAoVCapability.isImprovedCentered(entity, cap) ? this.getMaxCharges() : super.getExtraCharges(entity, cap);
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 0.0;
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean shouldDisable(@Nullable EntityPlayer caster, IAoVCapability cap) {
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH, null);
        return poly == null || poly.getMorph() != IPolymorphCapability.Morph.Wolf;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        return FuriousClaw.invoke((byte)4, caster, this);
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public boolean runOnClient() {
        return true;
    }
}

