/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellLightningStorm;
import tamaized.aov.common.helper.UtilHelper;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class LightningStorm
extends AbilityBase {
    private static final String UNLOC = "aov.spells.litstorm";
    private static final float DAMAGE = 3.0f;
    private static final int RANGE = 25;
    private static final int CHARGES = 2;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/lightningstorm.png");

    public LightningStorm() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{2}), new TextComponentTranslation("aov.spells.global.range", new Object[]{25}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{Float.valueOf(3.0f)}), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 2;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 25.0;
    }

    @Override
    public int getCoolDown() {
        return 45;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return IAoVCapability.selectiveTarget((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)caster, CapabilityList.AOV, null);
        if (cap == null) {
            return false;
        }
        float damage = 3.0f * (1.0f + cap.getSpellPower() / 100.0f);
        EntitySpellLightningStorm storm = new EntitySpellLightningStorm(caster.field_70170_p, (EntityLivingBase)caster, damage);
        Vec3d pos = UtilHelper.getSpellLocation(caster, 25, (Entity)target);
        if (pos.equals((Object)caster.func_174791_d())) {
            return false;
        }
        storm.func_70107_b(pos.field_72450_a, pos.field_72448_b + 10.0, pos.field_72449_c);
        caster.field_70170_p.func_72838_d((Entity)storm);
        caster.field_70170_p.func_184148_a(null, storm.field_70165_t, storm.field_70163_u, storm.field_70161_v, SoundEvents.field_191248_br, SoundCategory.PLAYERS, 4.0f, caster.func_70681_au().nextFloat() * 0.5f + 0.5f);
        return true;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }
}

