/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.tammodized.common.helper.CapabilityHelper;
import tamaized.tammodized.common.helper.RayTraceHelper;

public class EntityGravity
extends Entity {
    private final List<Entity> alreadyHit = Lists.newArrayList();
    public float spinnyBoi;
    private Entity caster;
    private float damage = 1.0f;
    private float damageMod = 1.0f;

    public EntityGravity(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
    }

    public EntityGravity(World world, Entity entity, float dmg, int r) {
        this(world);
        RayTraceResult ray;
        this.caster = entity;
        this.damage = dmg;
        if (this.caster instanceof EntityPlayer && (ray = RayTraceHelper.tracePath((World)world, (EntityPlayer)((EntityPlayer)this.caster), (int)r, (float)1.0f, (HashSet)Sets.newHashSet((Object[])new Entity[]{this.caster}))) != null) {
            BlockPos pos = ray.field_72313_a == RayTraceResult.Type.BLOCK ? ray.func_178782_a() : ray.field_72308_g.func_180425_c();
            this.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public EntityGravity(World world, Entity entity, float dmg, Vec3d pos) {
        this(world);
        this.caster = entity;
        this.damage = dmg;
        this.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa >= 50) {
            this.func_70106_y();
            return;
        }
        int range = 4;
        for (EntityLivingBase e : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.func_180425_c().func_177982_a(-range, -2, -range), this.func_180425_c().func_177982_a(range, 2, range)))) {
            if (e == this.caster || this.alreadyHit.contains(e)) continue;
            this.doDamage(e);
            this.alreadyHit.add((Entity)e);
        }
    }

    private void doDamage(EntityLivingBase e) {
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)this.caster, CapabilityList.AOV, null);
        if (cap != null) {
            if (IAoVCapability.selectiveTarget(this.caster, cap, e)) {
                e.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), this.damage * this.damageMod);
                cap.addExp(this.caster, 20, Abilities.gravity);
            }
        } else {
            e.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), this.damage * this.damageMod);
        }
        if (this.damageMod > 0.5f) {
            this.damageMod -= 0.1f;
        }
    }
}

