/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.Aura;
import tamaized.aov.common.core.skills.AoVSkill;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class ClientPacketHandlerAoVData
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, EntityPlayer player) {
        IPolymorphCapability poly;
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.AOV, null);
        if (cap != null) {
            cap.getObtainedSkills().clear();
            for (AoVSkill skill : message.obtainedSkills) {
                cap.addObtainedSkill(skill);
            }
            cap.setSkillPoints(message.skillPoints);
            cap.setExp(message.exp);
            cap.setMaxLevel(message.maxLevel);
            cap.toggleInvokeMass(message.invokeMass);
            for (int index = 0; index < 9; ++index) {
                cap.setSlot(message.slots[index], index, true);
            }
            cap.setCurrentSlot(message.currentSlot);
            cap.setCooldowns(Collections.unmodifiableMap(message.cooldowns));
            cap.clearAuras();
            for (Aura aura : message.auras) {
                cap.addAura(aura);
            }
            cap.markDirty();
            cap.setLoaded();
        }
        if ((poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH, null)) != null) {
            poly.morph(message.polymorph);
            poly.setFlagBits(message.renderBits);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerAoVData.processPacket(message, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        return null;
    }

    public static class Packet
    implements IMessage {
        private List<AoVSkill> obtainedSkills = Lists.newArrayList();
        private int skillPoints;
        private int exp;
        private int maxLevel;
        private boolean invokeMass;
        private Ability[] slots = new Ability[]{null, null, null, null, null, null, null, null, null};
        private int currentSlot;
        private IPolymorphCapability.Morph polymorph;
        private byte renderBits;
        private Map<AbilityBase, Integer> cooldowns = new HashMap<AbilityBase, Integer>();
        private List<Aura> auras = Lists.newArrayList();

        public Packet() {
        }

        public Packet(IAoVCapability cap, IPolymorphCapability poly) {
            this.obtainedSkills = cap.getObtainedSkills();
            this.skillPoints = cap.getSkillPoints();
            this.exp = cap.getExp();
            this.maxLevel = cap.getMaxLevel();
            this.invokeMass = cap.getInvokeMass();
            this.slots = cap.getSlots();
            this.currentSlot = cap.getCurrentSlot();
            this.cooldowns = cap.getCooldowns();
            this.polymorph = poly.getMorph();
            this.renderBits = poly.getFlagBits();
            this.auras = cap.getAuras();
        }

        public void fromBytes(ByteBuf stream) {
            int index;
            this.obtainedSkills.clear();
            int size = stream.readInt();
            for (index = 0; index < size; ++index) {
                this.obtainedSkills.add(AoVSkills.getSkillFromID(stream.readInt()));
            }
            this.skillPoints = stream.readInt();
            this.exp = stream.readInt();
            this.maxLevel = stream.readInt();
            this.invokeMass = stream.readBoolean();
            for (index = 0; index < 9; ++index) {
                this.slots[index] = stream.readBoolean() ? Ability.construct(stream) : null;
            }
            this.currentSlot = stream.readInt();
            this.cooldowns.clear();
            size = stream.readInt();
            for (index = 0; index < size; ++index) {
                this.cooldowns.put(AbilityBase.getAbilityFromID(stream.readInt()), stream.readInt());
            }
            this.polymorph = IPolymorphCapability.Morph.getMorph(stream.readInt());
            this.renderBits = stream.readByte();
            this.auras.clear();
            size = stream.readInt();
            for (index = 0; index < size; ++index) {
                this.auras.add(Aura.construct(stream));
            }
        }

        public void toBytes(ByteBuf stream) {
            stream.writeInt(this.obtainedSkills.size());
            for (AoVSkill skill : this.obtainedSkills) {
                stream.writeInt(skill == null ? -1 : skill.getID());
            }
            stream.writeInt(this.skillPoints);
            stream.writeInt(this.exp);
            stream.writeInt(this.maxLevel);
            stream.writeBoolean(this.invokeMass);
            for (int index = 0; index < 9; ++index) {
                Ability ability = this.slots[index];
                if (ability == null) {
                    stream.writeBoolean(false);
                    continue;
                }
                stream.writeBoolean(true);
                ability.encode(stream);
            }
            stream.writeInt(this.currentSlot);
            stream.writeInt(this.cooldowns.size());
            for (Map.Entry<AbilityBase, Integer> entry : this.cooldowns.entrySet()) {
                stream.writeInt(entry.getKey().getID());
                stream.writeInt(entry.getValue().intValue());
            }
            stream.writeInt(this.polymorph == null ? -1 : this.polymorph.ordinal());
            stream.writeByte((int)this.renderBits);
            stream.writeInt(this.auras.size());
            for (Aura aura : this.auras) {
                aura.encode(stream);
            }
        }
    }
}

