/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Aura;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class ClientPacketHandlerAoVSimpleData
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, World world) {
        IPolymorphCapability poly;
        Entity entity = world.func_73045_a(message.id);
        IAoVCapability cap = (IAoVCapability)CapabilityHelper.getCap((ICapabilityProvider)entity, CapabilityList.AOV, null);
        if (cap != null) {
            cap.clearAuras();
            for (Aura aura : message.auras) {
                cap.addAura(aura);
            }
        }
        if ((poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)entity, CapabilityList.POLYMORPH, null)) != null) {
            poly.morph(message.polymorph);
            poly.setFlagBits(message.renderBits);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerAoVSimpleData.processPacket(message, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private int id;
        private List<Aura> auras = Lists.newArrayList();
        private IPolymorphCapability.Morph polymorph;
        private byte renderBits;

        public Packet() {
        }

        public Packet(IAoVCapability cap, IPolymorphCapability poly, int entityID) {
            this.auras = cap.getAuras();
            this.polymorph = poly.getMorph();
            this.renderBits = poly.getFlagBits();
            this.id = entityID;
        }

        public void fromBytes(ByteBuf stream) {
            this.id = stream.readInt();
            int size = stream.readInt();
            for (int index = 0; index < size; ++index) {
                this.auras.add(Aura.construct(stream));
            }
            this.polymorph = IPolymorphCapability.Morph.getMorph(stream.readInt());
            this.renderBits = stream.readByte();
        }

        public void toBytes(ByteBuf stream) {
            stream.writeInt(this.id);
            stream.writeInt(this.auras.size());
            for (Aura aura : this.auras) {
                aura.encode(stream);
            }
            stream.writeInt(this.polymorph == null ? -1 : this.polymorph.ordinal());
            stream.writeByte((int)this.renderBits);
        }
    }
}

