/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.astro.IAstroCapability;

public class ClientPacketHandlerAstroAnimation
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, World world) {
        IAstroCapability cap;
        EntityPlayer player;
        Entity e = world.func_73045_a(message.entityID);
        if (e instanceof EntityPlayer && (player = (EntityPlayer)e).hasCapability(CapabilityList.ASTRO, null) && (cap = (IAstroCapability)player.getCapability(CapabilityList.ASTRO, null)) != null) {
            cap.playAnimation((EntityLivingBase)player, message.animation);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerAstroAnimation.processPacket(message, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private int entityID;
        private IAstroCapability.IAnimation animation;

        public Packet() {
        }

        public Packet(EntityLivingBase entity, IAstroCapability.IAnimation a) {
            if (entity.hasCapability(CapabilityList.ASTRO, null)) {
                IAstroCapability cap = (IAstroCapability)entity.getCapability(CapabilityList.ASTRO, null);
                if (cap == null) {
                    return;
                }
                this.entityID = entity.func_145782_y();
                this.animation = a;
            }
        }

        public void fromBytes(ByteBuf stream) {
            this.entityID = stream.readInt();
            this.animation = IAstroCapability.IAnimation.getAnimationFromID(stream.readInt());
        }

        public void toBytes(ByteBuf stream) {
            stream.writeInt(this.entityID);
            stream.writeInt(IAstroCapability.IAnimation.getAnimationID(this.animation));
        }
    }
}

