/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class ClientPacketHandlerLeap
implements IMessageHandler<Packet, IMessage> {
    @SideOnly(value=Side.CLIENT)
    private static void processPacket(Packet message, World world) {
        ILeapCapability cap;
        Entity e = world.func_73045_a(message.entityID);
        if (e != null && (cap = (ILeapCapability)CapabilityHelper.getCap((ICapabilityProvider)e, CapabilityList.LEAP, null)) != null) {
            cap.setLeapDuration(message.duration);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(Packet message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> ClientPacketHandlerLeap.processPacket(message, (World)Minecraft.func_71410_x().field_71441_e));
        return null;
    }

    public static class Packet
    implements IMessage {
        private int entityID;
        private int duration;

        public Packet() {
        }

        public Packet(Entity entity, ILeapCapability cap) {
            this.entityID = entity.func_145782_y();
            this.duration = cap.getLeapDuration();
        }

        public void fromBytes(ByteBuf stream) {
            this.entityID = stream.readInt();
            this.duration = stream.readInt();
        }

        public void toBytes(ByteBuf stream) {
            stream.writeInt(this.entityID);
            stream.writeInt(this.duration);
        }
    }
}

