/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.server;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.skills.AoVSkill;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.tammodized.common.helper.CapabilityHelper;

public class ServerPacketHandlerSpellSkill
implements IMessageHandler<Packet, IMessage> {
    private static void processPacket(Packet message, EntityPlayerMP player, World world) {
        if (!player.hasCapability(CapabilityList.AOV, null)) {
            return;
        }
        IAoVCapability cap = (IAoVCapability)player.getCapability(CapabilityList.AOV, null);
        IPolymorphCapability poly = (IPolymorphCapability)CapabilityHelper.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH, null);
        if (cap == null) {
            return;
        }
        switch (message.id) {
            case CAST_SPELL: {
                Entity e;
                Ability ability;
                if (message.data.length <= 0 || (ability = cap.getSlot(message.data[0])) == null) break;
                if (message.data.length > 1 && (e = world.func_73045_a(message.data[1])) instanceof EntityLivingBase) {
                    ability.cast((EntityPlayer)player, (EntityLivingBase)e);
                    break;
                }
                ability.cast((EntityPlayer)player);
                break;
            }
            case SKILLEDIT_CHECK_CANOBTAIN: {
                AoVSkill skillToCheck;
                if (message.data.length <= 0 || (skillToCheck = AoVSkills.getSkillFromID(message.data[0])) == null || skillToCheck.getParent() != null && !cap.hasSkill(skillToCheck.getParent()) || cap.getSkillPoints() < skillToCheck.getCost() || cap.getLevel() < skillToCheck.getLevel() || cap.getSpentSkillPoints() < skillToCheck.getSpentPoints() || skillToCheck.isClassCore() && cap.hasCoreSkill() || skillToCheck.getParent() != null && !cap.hasSkill(skillToCheck.getParent())) break;
                cap.addObtainedSkill(skillToCheck);
                cap.setSkillPoints(cap.getSkillPoints() - skillToCheck.getCost());
                break;
            }
            case RESETSKILLS_FULL: {
                cap.reset(true);
                if (poly == null) break;
                poly.morph(null);
                break;
            }
            case RESETSKILLS_MINOR: {
                cap.reset(false);
                if (poly == null) break;
                poly.morph(null);
                break;
            }
            case SPELLBAR_REMOVE: {
                if (message.data.length <= 0) break;
                cap.removeSlot(message.data[0]);
                break;
            }
            case SPELLBAR_ADDNEAR: {
                cap.addToNearestSlot(message.ability);
                break;
            }
        }
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        MinecraftServer server = player.func_184102_h();
        if (server != null) {
            server.func_152344_a(() -> ServerPacketHandlerSpellSkill.processPacket(message, player, player.field_70170_p));
        }
        return null;
    }

    public static class Packet
    implements IMessage {
        public PacketType id;
        public int[] data = new int[0];
        public AbilityBase ability;

        public Packet() {
        }

        public Packet(PacketType type, @Nullable AbilityBase ability, int ... data) {
            this.id = type;
            this.data = data;
            this.ability = ability;
        }

        public void fromBytes(ByteBuf buf) {
            PacketType[] types = PacketType.values();
            int i = buf.readInt();
            this.id = i >= types.length ? null : types[i];
            int size = buf.readInt();
            this.data = new int[size];
            for (int index = 0; index < size; ++index) {
                this.data[index] = buf.readInt();
            }
            this.ability = AbilityBase.getAbilityFromID(buf.readInt());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id.ordinal());
            buf.writeInt(this.data.length);
            for (int dat : this.data) {
                buf.writeInt(dat);
            }
            buf.writeInt(AbilityBase.getID(this.ability));
        }

        public static enum PacketType {
            SKILLEDIT_CHECK_CANOBTAIN,
            RESETSKILLS_FULL,
            RESETSKILLS_MINOR,
            SPELLBAR_REMOVE,
            SPELLBAR_ADDNEAR,
            CAST_SPELL;

        }
    }
}

