/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.registry;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tamaized.aov.AoV;
import tamaized.aov.network.client.ClientPacketHandlerParticle;

public class ParticleRegistry {
    private static final List<IParticleHandler> HANDLERS = Lists.newArrayList();

    public static int register(IParticleHandler handler) {
        HANDLERS.add(handler);
        return HANDLERS.size() - 1;
    }

    public static IParticleHandler getHandlerFromID(int id) {
        return id < 0 || id >= HANDLERS.size() ? null : HANDLERS.get(id);
    }

    public static void spawnFromServer(World world, int id, double x, double y, double z, double dx, double dy, double dz, int ... data) {
        AoV.network.sendToAllAround((IMessage)new ClientPacketHandlerParticle.Packet(id, x, y, z, dx, dy, dz, data), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, 64.0));
    }

    public static interface IParticleHandler {
        @SideOnly(value=Side.CLIENT)
        public void execute(ParticleManager var1, World var2, double var3, double var5, double var7, double var9, double var11, double var13, int ... var15);
    }
}

