/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.astro.AstroCapabilityHandler;
import tamaized.aov.common.capabilities.astro.IAstroCapability;

@Mod.EventBusSubscriber(modid="aov", value={Dist.CLIENT})
public class RenderAstro {
    private static final ResourceLocation TEXTURE_CARDS = new ResourceLocation("aov", "textures/entity/cards.png");
    private static final ResourceLocation TEXTURE_RUNE = new ResourceLocation("aov", "textures/entity/rune.png");
    public static float testVarPleaseIgnore = 0.0f;

    @SubscribeEvent
    public static void render(RenderPlayerEvent.Post e) {
        EntityPlayer player = e.getEntityPlayer();
        IAstroCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.ASTRO);
        if (cap == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)e.getX(), (double)e.getY(), (double)e.getZ());
        AstroCapabilityHandler handler = cap instanceof AstroCapabilityHandler ? (AstroCapabilityHandler)cap : null;
        block7: for (IAstroCapability.IAnimation animation : cap.getAnimations()) {
            if (animation == null) continue;
            switch (animation) {
                case Draw: {
                    RenderAstro.renderDraw(0, e, cap, handler != null ? handler.lastDraw : cap.getDraw());
                    continue block7;
                }
                case Spread: {
                    RenderAstro.renderSpread(2, e, cap, handler != null ? handler.lastSpread : cap.getSpread());
                    continue block7;
                }
                case Burn: {
                    RenderAstro.renderBurn(1, e, cap);
                    continue block7;
                }
                case Activate: {
                    RenderAstro.renderBurn(3, e, cap);
                    continue block7;
                }
                case Redraw: {
                    RenderAstro.renderRedraw(4, e, cap);
                    continue block7;
                }
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void tick(TickEvent.RenderTickEvent e) {
        float timer;
        int index;
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O != 0 || mc.field_71439_g == null) {
            return;
        }
        IAstroCapability cap = CapabilityList.getCap((ICapabilityProvider)mc.field_71439_g, CapabilityList.ASTRO);
        if (cap == null) {
            return;
        }
        for (index = 1; index <= 3; index += 2) {
            timer = cap.getFrameData()[index][3];
            cap.getFrameData()[index][1] = Math.max(0.0f, cap.getFrameData()[index][1] - 240.0f * (cap.getFrameData()[1][1] / 90.0f) / (float)Minecraft.func_175610_ah());
            if (!(cap.getFrameData()[index][0] > 0.0f) || Minecraft.func_71410_x().func_147113_T() || !(timer < 20.0f)) continue;
            cap.getFrameData()[index][0] = Math.max(0.0f, cap.getFrameData()[index][0] - 240.0f / (float)Minecraft.func_175610_ah());
        }
        if (!Minecraft.func_71410_x().func_147113_T()) {
            float[] fArray = cap.getFrameData()[2];
            fArray[4] = fArray[4] + 240.0f / (float)Minecraft.func_175610_ah() % 360.0f;
            float[] fArray2 = cap.getFrameData()[2];
            fArray2[5] = fArray2[5] + (cap.getFrameData()[2][5] >= 90.0f && cap.getFrameData()[2][3] > 35.0f ? 0.0f : 60.0f) / (float)Minecraft.func_175610_ah();
        }
        for (index = 0; index <= 2; index += 2) {
            timer = cap.getFrameData()[index][3];
            if (timer < 60.0f && !Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[index][2] > 0.0f) {
                cap.getFrameData()[index][2] = Math.max(0.0f, cap.getFrameData()[index][2] - 240.0f / (float)Minecraft.func_175610_ah());
            }
            if (timer < 90.0f && !Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[index][1] > 0.0f) {
                cap.getFrameData()[index][1] = Math.max(0.0f, cap.getFrameData()[index][1] - 160.0f / (float)Minecraft.func_175610_ah());
            }
            if (!(cap.getFrameData()[index][0] > 0.0f) || Minecraft.func_71410_x().func_147113_T() || !(timer < 25.0f)) continue;
            cap.getFrameData()[index][0] = Math.max(0.0f, cap.getFrameData()[index][0] - 240.0f / (float)Minecraft.func_175610_ah());
        }
        if (!Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[4][0] > 0.0f) {
            float[] fArray = cap.getFrameData()[4];
            fArray[0] = fArray[0] - 240.0f / (float)Minecraft.func_175610_ah();
        }
        if (!Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[4][1] > 0.0f) {
            float[] fArray = cap.getFrameData()[4];
            fArray[1] = fArray[1] - 120.0f / (float)Minecraft.func_175610_ah();
        }
        if (!Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[4][0] <= 0.0f) {
            float[] fArray = cap.getFrameData()[4];
            fArray[4] = fArray[4] - 60.0f / (float)Minecraft.func_175610_ah();
        }
        if (!Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[4][4] <= 0.0f) {
            float[] fArray = cap.getFrameData()[4];
            fArray[2] = fArray[2] - 300.0f / (float)Minecraft.func_175610_ah();
        }
    }

    private static void renderRedraw(int index, RenderPlayerEvent.Post e, IAstroCapability cap) {
        float timer = cap.getFrameData()[index][3];
        if (timer > 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179114_b((float)(-e.getEntityPlayer().field_70761_aq), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)1.5, (double)1.0);
            if (!Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[index][0] > 0.0f) {
                float[] fArray = cap.getFrameData()[index];
                fArray[0] = fArray[0] - 240.0f / (float)Minecraft.func_175610_ah();
            }
            GlStateManager.func_179114_b((float)(cap.getFrameData()[index][0] % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            if (!Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[index][1] > 0.0f) {
                float[] fArray = cap.getFrameData()[index];
                fArray[1] = fArray[1] - 120.0f / (float)Minecraft.func_175610_ah();
            }
            float s = (80.0f - cap.getFrameData()[index][1]) / 80.0f;
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            float f = 1.5f;
            float scale = 0.3f;
            e.getRenderer().func_110776_a(TEXTURE_CARDS);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            if (!Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[index][0] <= 0.0f) {
                float[] fArray = cap.getFrameData()[index];
                fArray[4] = fArray[4] - 60.0f / (float)Minecraft.func_175610_ah();
            }
            if (!Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[index][4] <= 0.0f) {
                float[] fArray = cap.getFrameData()[index];
                fArray[2] = fArray[2] - 300.0f / (float)Minecraft.func_175610_ah();
            }
            for (int i = 0; i <= 12; ++i) {
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                if (i > 0) {
                    GlStateManager.func_179114_b((float)30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
                float xpos = -0.15f;
                float ypos = -0.435f;
                float uScale = 10.416667f;
                float u = cap.getFrameData()[index][2] > (float)(i - 1) * uScale ? Math.max(0.0f, (float)i * uScale - cap.getFrameData()[index][2]) / uScale : 1.0f;
                vertexbuffer.func_181662_b((double)(xpos + scale), (double)(ypos + 1.0f), 0.0).func_187315_a(0.0, 0.5).func_181675_d();
                vertexbuffer.func_181662_b((double)(xpos + scale), (double)(ypos + 1.0f + f * scale), 0.0).func_187315_a(0.0, (double)(0.5f - 0.5f * (f / 1.5f))).func_181675_d();
                vertexbuffer.func_181662_b((double)(xpos + scale * u), (double)(ypos + 1.0f + f * scale), 0.0).func_187315_a(0.25 * (double)(1.0f - u), (double)(0.5f - 0.5f * (f / 1.5f))).func_181675_d();
                vertexbuffer.func_181662_b((double)(xpos + scale * u), (double)(ypos + 1.0f), 0.0).func_187315_a(0.25 * (double)(1.0f - u), 0.5).func_181675_d();
                tessellator.func_78381_a();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderBurn(int index, RenderPlayerEvent.Post e, IAstroCapability cap) {
        float timer = cap.getFrameData()[index][3];
        if (timer > 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179114_b((float)(180.0f - e.getRenderer().func_177068_d().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.125, (double)(0.5f + MathHelper.func_76134_b((float)((float)Math.toRadians(cap.getFrameData()[index][1])))), (double)-0.125);
            cap.getFrameData()[index][1] = Math.max(0.0f, cap.getFrameData()[index][1] - 240.0f * (cap.getFrameData()[index][1] / 90.0f) / (float)Minecraft.func_175610_ah());
            float ftimer = cap.getFrameData()[index][0];
            if (cap.getFrameData()[index][0] > 0.0f && !Minecraft.func_71410_x().func_147113_T() && timer < 20.0f) {
                cap.getFrameData()[index][0] = Math.max(0.0f, cap.getFrameData()[index][0] - 240.0f / (float)Minecraft.func_175610_ah());
            }
            float f = ftimer > 0.0f ? ftimer / 80.0f * 1.5f : 0.0f;
            float scale = 0.25f;
            e.getRenderer().func_110776_a(TEXTURE_CARDS);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b((double)(1.0f * scale), 1.0, 1.0E-4).func_187315_a(0.0, 0.5).func_181675_d();
            vertexbuffer.func_181662_b((double)(1.0f * scale), (double)(1.0f + f * scale), 1.0E-4).func_187315_a(0.0, (double)(0.5f - 0.5f * (f / 1.5f))).func_181675_d();
            vertexbuffer.func_181662_b(0.0, (double)(1.0f + f * scale), 1.0E-4).func_187315_a(0.25, (double)(0.5f - 0.5f * (f / 1.5f))).func_181675_d();
            vertexbuffer.func_181662_b(0.0, 1.0, 1.0E-4).func_187315_a(0.25, 0.5).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderDraw(int index, RenderPlayerEvent.Post e, IAstroCapability cap, IAstroCapability.ICard card) {
        float timer = cap.getFrameData()[index][3];
        if (timer > 0.0f) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179114_b((float)(180.0f + cap.getFrameData()[index][2] - e.getRenderer().func_177068_d().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            if (timer < 60.0f && !Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[index][2] > 0.0f) {
                cap.getFrameData()[index][2] = Math.max(0.0f, cap.getFrameData()[index][2] - 240.0f / (float)Minecraft.func_175610_ah());
            }
            GlStateManager.func_179137_b((double)-0.5, (double)1.0, (double)0.0);
            if (timer < 90.0f && !Minecraft.func_71410_x().func_147113_T() && cap.getFrameData()[index][1] > 0.0f) {
                cap.getFrameData()[index][1] = Math.max(0.0f, cap.getFrameData()[index][1] - 160.0f / (float)Minecraft.func_175610_ah());
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((80.0f - cap.getFrameData()[index][1]) / 80.0f));
            float ftimer = cap.getFrameData()[index][0];
            if (cap.getFrameData()[index][0] > 0.0f && !Minecraft.func_71410_x().func_147113_T() && timer < 25.0f) {
                cap.getFrameData()[index][0] = Math.max(0.0f, cap.getFrameData()[index][0] - 240.0f / (float)Minecraft.func_175610_ah());
            }
            float f = ftimer > 0.0f ? ftimer / 80.0f * 1.5f : 0.0f;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            e.getRenderer().func_110776_a(TEXTURE_CARDS);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(1.0, 1.0, -1.0E-4).func_187315_a(0.0, 0.5).func_181675_d();
            vertexbuffer.func_181662_b(1.0, (double)(1.0f + f), -1.0E-4).func_187315_a(0.0, (double)(0.5f - 0.5f * (f / 1.5f))).func_181675_d();
            vertexbuffer.func_181662_b(0.0, (double)(1.0f + f), -1.0E-4).func_187315_a(0.25, (double)(0.5f - 0.5f * (f / 1.5f))).func_181675_d();
            vertexbuffer.func_181662_b(0.0, 1.0, -1.0E-4).func_187315_a(0.25, 0.5).func_181675_d();
            int cardID = IAstroCapability.ICard.getCardID(card) + 1;
            double uv = 0.5 * Math.floor(cardID / 4);
            vertexbuffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(0.25 * (double)cardID % 4.0, 0.5 + uv).func_181675_d();
            vertexbuffer.func_181662_b(1.0, (double)(1.0f + f), 0.0).func_187315_a(0.25 * (double)cardID % 4.0, (double)(0.5f - 0.5f * (f / 1.5f)) + uv).func_181675_d();
            vertexbuffer.func_181662_b(0.0, (double)(1.0f + f), 0.0).func_187315_a(0.25 + 0.25 * (double)cardID % 4.0, (double)(0.5f - 0.5f * (f / 1.5f)) + uv).func_181675_d();
            vertexbuffer.func_181662_b(0.0, 1.0, 0.0).func_187315_a(0.25 + 0.25 * (double)cardID % 4.0, 0.5 + uv).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderSpread(int index, RenderPlayerEvent.Post e, IAstroCapability cap, IAstroCapability.ICard card) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179114_b((float)(90.0f - e.getRenderer().func_177068_d().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.2f, (double)2.2f, (double)0.05f);
        GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (!Minecraft.func_71410_x().func_147113_T()) {
            float[] fArray = cap.getFrameData()[index];
            fArray[4] = fArray[4] + 240.0f / (float)Minecraft.func_175610_ah() % 360.0f;
        }
        GlStateManager.func_179114_b((float)cap.getFrameData()[index][4], (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-1.45f, (double)-1.55f, (double)0.0);
        if (!Minecraft.func_71410_x().func_147113_T()) {
            float[] fArray = cap.getFrameData()[index];
            fArray[5] = fArray[5] + (cap.getFrameData()[index][5] >= 90.0f && cap.getFrameData()[index][3] > 35.0f ? 0.0f : 60.0f) / (float)Minecraft.func_175610_ah();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)MathHelper.func_76126_a((float)((float)Math.toRadians(Math.min(cap.getFrameData()[index][5], 180.0f)))));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        e.getRenderer().func_110776_a(TEXTURE_RUNE);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(3.0, 3.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(3.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 3.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderAstro.renderDraw(index, e, cap, card);
    }
}

