/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.Heightmap;
import tamaized.aov.common.entity.EntitySpellLightningStorm;

public class RenderSpellLightingStorm
extends Render<EntitySpellLightningStorm> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("aov", "textures/entity/cloud.png");
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    static float[] rainXCoords = new float[1024];
    static float[] rainYCoords = new float[1024];
    Random random = new Random();
    int lastTick;
    int nextCloud = 1;

    public RenderSpellLightingStorm(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void doRender(@Nonnull EntitySpellLightningStorm entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (this.lastTick != entity.field_70173_aa && entity.field_70173_aa % this.nextCloud == 0) {
            this.nextCloud = 10 + entity.field_70170_p.field_73012_v.nextInt(20);
            this.lastTick = entity.field_70173_aa;
            entity.clouds.add(new EntitySpellLightningStorm.Cloud());
        }
        GlStateManager.func_179094_E();
        this.renderRain(entity, partialTicks);
        this.func_110776_a(TEXTURE);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179103_j((int)7425);
        entity.clouds.sort((o1, o2) -> {
            double dist2;
            double dist1;
            boolean reverse = false;
            Entity view = Minecraft.func_71410_x().func_175606_aa();
            if (view == null) {
                view = entity;
                reverse = true;
            }
            return (dist1 = view.func_70092_e(entity.field_70165_t + o1.offset.field_72450_a, entity.field_70163_u + o1.offset.field_72448_b, entity.field_70161_v + o1.offset.field_72449_c)) == (dist2 = view.func_70092_e(entity.field_70165_t + o2.offset.field_72450_a, entity.field_70163_u + o2.offset.field_72448_b, entity.field_70161_v + o2.offset.field_72449_c)) ? 0 : (reverse ? (dist1 > dist2 ? 1 : -1) : (dist1 > dist2 ? -1 : 1));
        });
        entity.clouds.removeIf(c -> c.render(entity, x, y, z, partialTicks, this.field_76990_c));
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntitySpellLightningStorm entity) {
        return null;
    }

    private void renderRain(EntitySpellLightningStorm storm, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        if (entity == null) {
            return;
        }
        float f = 1.0f;
        WorldClient world = mc.field_71441_e;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70163_u);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        int l = MathHelper.func_76128_c((double)d1);
        int i1 = 5;
        if (mc.field_71474_y.field_74347_j) {
            i1 = 10;
        }
        int j1 = -1;
        bufferbuilder.func_178969_c(-d0, -d1, -d2);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int z = k - i1; z <= k + i1; ++z) {
            for (int x = i - i1; x <= i + i1; ++x) {
                if (!((double)x >= storm.field_70165_t - (double)(storm.field_70130_N / 4.0f)) || !((double)x <= storm.field_70165_t + (double)(storm.field_70130_N / 4.0f)) || !((double)z >= storm.field_70161_v - (double)(storm.field_70130_N / 4.0f)) || !((double)z <= storm.field_70161_v + (double)(storm.field_70130_N / 4.0f))) continue;
                int i2 = (z - k + 16) * 32 + x - i + 16;
                double d3 = (double)rainXCoords[i2] * 0.5;
                double d4 = (double)rainYCoords[i2] * 0.5;
                blockpos$mutableblockpos.func_181079_c(x, 0, z);
                int j2 = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)blockpos$mutableblockpos).func_177956_o();
                int k2 = (int)Math.min(storm.field_70163_u, (double)(j - i1));
                int l2 = (int)Math.min(storm.field_70163_u, (double)(j + i1));
                if (k2 < j2) {
                    k2 = j2;
                }
                if (l2 < j2) {
                    l2 = j2;
                }
                int i3 = j2;
                if (j2 < l) {
                    i3 = l;
                }
                if (k2 == l2) continue;
                this.random.setSeed(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761);
                blockpos$mutableblockpos.func_181079_c(x, k2, z);
                if (j1 != 0) {
                    j1 = 0;
                    mc.func_110434_K().func_110577_a(RAIN_TEXTURES);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                }
                double d5 = -((double)(entity.field_70173_aa + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                double d6 = (double)((float)x + 0.5f) - entity.field_70165_t;
                double d7 = (double)((float)z + 0.5f) - entity.field_70161_v;
                float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                blockpos$mutableblockpos.func_181079_c(x, i3, z);
                int j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                int k3 = j3 >> 16 & 0xFFFF;
                int l3 = j3 & 0xFFFF;
                bufferbuilder.func_181662_b((double)x - d3 + 0.5, (double)l2, (double)z - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                bufferbuilder.func_181662_b((double)x + d3 + 0.5, (double)l2, (double)z + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                bufferbuilder.func_181662_b((double)x + d3 + 0.5, (double)k2, (double)z + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                bufferbuilder.func_181662_b((double)x - d3 + 0.5, (double)k2, (double)z - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
            }
        }
        if (j1 != -1) {
            tessellator.func_78381_a();
        }
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    static {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                RenderSpellLightingStorm.rainXCoords[i << 5 | j] = -f1 / f2;
                RenderSpellLightingStorm.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }
}

