/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.capabilities.stun.IStunCapability;

@Mod.EventBusSubscriber(modid="aov")
public class CapabilityList {
    @CapabilityInject(value=IAoVCapability.class)
    public static final Capability<IAoVCapability> AOV = null;
    @CapabilityInject(value=IAstroCapability.class)
    public static final Capability<IAstroCapability> ASTRO = null;
    @CapabilityInject(value=IStunCapability.class)
    public static final Capability<IStunCapability> STUN = null;
    @CapabilityInject(value=ILeapCapability.class)
    public static final Capability<ILeapCapability> LEAP = null;
    @CapabilityInject(value=IPolymorphCapability.class)
    public static final Capability<IPolymorphCapability> POLYMORPH = null;

    public static <T> T getCap(@Nullable ICapabilityProvider provider, Capability<T> cap) {
        return CapabilityList.getCap(provider, cap, null);
    }

    public static <T> T getCap(@Nullable ICapabilityProvider provider, Capability<T> cap, @Nullable EnumFacing face) {
        LazyOptional data = provider != null ? provider.getCapability(cap, face) : null;
        return (T)(data != null && data.isPresent() ? data.orElseThrow(IllegalStateException::new) : null);
    }

    @SubscribeEvent
    public static void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayer) {
            e.addCapability(IAoVCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IAoVCapability inst = (IAoVCapability)AOV.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return AOV.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)AOV.getStorage().writeNBT(AOV, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    AOV.getStorage().readNBT(AOV, (Object)this.inst, null, (INBTBase)nbt);
                }
            });
            e.addCapability(IAstroCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IAstroCapability inst = (IAstroCapability)ASTRO.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return ASTRO.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)ASTRO.getStorage().writeNBT(ASTRO, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    ASTRO.getStorage().readNBT(ASTRO, (Object)this.inst, null, (INBTBase)nbt);
                }
            });
            e.addCapability(IPolymorphCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IPolymorphCapability inst = (IPolymorphCapability)POLYMORPH.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return POLYMORPH.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)POLYMORPH.getStorage().writeNBT(POLYMORPH, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    POLYMORPH.getStorage().readNBT(POLYMORPH, (Object)this.inst, null, (INBTBase)nbt);
                }
            });
        }
        if (e.getObject() instanceof EntityLivingBase) {
            e.addCapability(IStunCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IStunCapability inst = (IStunCapability)STUN.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return STUN.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)STUN.getStorage().writeNBT(STUN, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    STUN.getStorage().readNBT(STUN, (Object)this.inst, null, (INBTBase)nbt);
                }
            });
            e.addCapability(ILeapCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                ILeapCapability inst = (ILeapCapability)LEAP.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    return LEAP.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LEAP.getStorage().writeNBT(LEAP, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    LEAP.getStorage().readNBT(LEAP, (Object)this.inst, null, (INBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void updateClone(PlayerEvent.Clone e) {
        IAoVCapability newcap = CapabilityList.getCap((ICapabilityProvider)e.getEntityPlayer(), AOV);
        IAoVCapability oldcap = CapabilityList.getCap((ICapabilityProvider)e.getOriginal(), AOV);
        if (newcap != null && oldcap != null) {
            newcap.copyFrom(oldcap);
        }
        IPolymorphCapability newpoly = CapabilityList.getCap((ICapabilityProvider)e.getEntityPlayer(), POLYMORPH);
        IPolymorphCapability oldpoly = CapabilityList.getCap((ICapabilityProvider)e.getOriginal(), POLYMORPH);
        if (newpoly != null && oldpoly != null) {
            newpoly.morph(oldpoly.getMorph());
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinWorldEvent e) {
        IAstroCapability astro;
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)e.getEntity(), AOV);
        if (cap != null) {
            cap.markDirty();
            cap.setLoaded();
        }
        if ((astro = CapabilityList.getCap((ICapabilityProvider)e.getEntity(), ASTRO)) != null) {
            astro.markDirty();
        }
    }
}

