/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.aov;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.PacketDistributor;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.Aura;
import tamaized.aov.common.core.skills.AoVSkill;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.aov.common.helper.FloatyTextHelper;
import tamaized.aov.network.client.ClientPacketHandlerAoVData;
import tamaized.aov.network.server.ServerPacketHandlerSpellSkill;
import tamaized.aov.proxy.ClientProxy;
import tamaized.aov.registry.AoVPotions;

public class AoVCapabilityHandler
implements IAoVCapability {
    public static final float xpScale = 2.5f;
    private static final String PALADIN_HEALTH_NAME = "AoV Paladin Health";
    private static final String DRUID_HEALTH_NAME = "AoV Druid Health";
    private static final Set<String> HEALTH_NAMES = ImmutableSet.of((Object)"AoV Defender Health", (Object)"AoV Paladin Health", (Object)"AoV Druid Health");
    private static final AttributeModifier PALADIN_HEALTH = new AttributeModifier("AoV Paladin Health", 10.0, 0);
    private int tick = 1;
    private boolean dirty = true;
    private boolean hasLoaded = false;
    private int currentSlot = 0;
    private List<AoVSkill> obtainedSkills = new ArrayList<AoVSkill>();
    private int skillPoints = 1;
    private int exp = 0;
    private int maxLevel;
    private boolean invokeMass;
    private Ability[] slots;
    private List<Ability> abilities;
    private float spellpower;
    private int extraCharges;
    private int dodge;
    private int doublestrike;
    private boolean selectiveFocus;
    private boolean hasInvoke;
    private List<Aura> auras;
    private Map<AbilityBase, DecayWrapper> decay;
    private Map<AbilityBase, Integer> cooldowns;
    private boolean hasAid;
    private boolean hasZeal;
    private boolean hasEwer;
    private boolean hasBalance;
    private boolean hasSpire;
    private boolean hasSpear;

    public AoVCapabilityHandler() {
        this.maxLevel = (Integer)AoV.config.maxlevel.get();
        this.invokeMass = false;
        this.slots = new Ability[]{null, null, null, null, null, null, null, null, null};
        this.abilities = new ArrayList<Ability>();
        this.spellpower = 0.0f;
        this.extraCharges = 0;
        this.dodge = 0;
        this.doublestrike = 0;
        this.selectiveFocus = false;
        this.hasInvoke = false;
        this.auras = new ArrayList<Aura>();
        this.decay = new HashMap<AbilityBase, DecayWrapper>();
        this.cooldowns = new HashMap<AbilityBase, Integer>();
        this.hasAid = false;
        this.hasZeal = false;
        this.hasEwer = false;
        this.hasBalance = false;
        this.hasSpire = false;
        this.hasSpear = false;
    }

    public static int getExpForLevel(IAoVCapability cap, int level) {
        return level > cap.getMaxLevel() ? 0 : AoVCapabilityHandler.getExpForLevel(level);
    }

    public static int getExpForLevel(int level) {
        return level < 1 ? 0 : (int)Math.floor(25.0f * ((2.5f + (float)(level - 2)) * (float)(level - 1)));
    }

    public static int getLevelFromExp(float xp) {
        double a = (-12.5 + Math.sqrt(25.0 * Math.pow(2.5, 2.0) - 125.0 + (double)(4.0f * (xp += 0.5f)) + 25.0) + 15.0) / 10.0;
        double b = (-12.5 - Math.sqrt(25.0 * Math.pow(2.5, 2.0) - 125.0 + (double)(4.0f * xp) + 25.0) + 15.0) / 10.0;
        return Math.max((int)a, (int)b);
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void setLoaded() {
        this.hasLoaded = true;
    }

    @Override
    public void reset(boolean b) {
        if (b) {
            this.obtainedSkills.clear();
            this.skillPoints = 1;
            this.exp = 0;
            this.maxLevel = (Integer)AoV.config.maxlevel.get();
            this.decay.clear();
        } else {
            AoVSkill core = this.getCoreSkill();
            this.obtainedSkills.clear();
            this.obtainedSkills.add(core);
            this.skillPoints = this.getLevel() - 1;
        }
        this.abilities.clear();
        this.auras.clear();
        this.invokeMass = false;
        this.slots = new Ability[]{null, null, null, null, null, null, null, null, null};
        this.dirty = true;
    }

    @Override
    public void update(@Nullable EntityPlayer player) {
        if (!this.hasLoaded) {
            return;
        }
        ++this.tick;
        this.checkState(player);
        this.updateAbilities(player);
        this.updateAuras(player);
        this.updateDecay();
        if (this.tick % 200 == 0) {
            this.dirty = true;
        }
        if (this.dirty) {
            this.updateValues(player);
            if (player instanceof EntityPlayerMP) {
                this.sendPacketUpdates((EntityPlayerMP)player);
            }
            this.dirty = false;
        }
        if (this.tick % 10 == 0) {
            this.updateHealth(player);
        }
        if (this.tick % 600 == 0 && this.hasSkill(AoVSkills.paladin_capstone) && player != null && !player.field_70128_L) {
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            if (!main.func_190926_b() && main.func_77973_b().isShield(main, (EntityLivingBase)player) && main.func_77973_b().isRepairable() && main.func_77952_i() > 0) {
                main.func_196085_b(0);
            }
            if (!off.func_190926_b() && off.func_77973_b().isShield(off, (EntityLivingBase)player) && off.func_77973_b().isRepairable() && off.func_77952_i() > 0) {
                off.func_196085_b(0);
            }
        }
    }

    private void checkState(@Nullable EntityPlayer player) {
        boolean spear;
        if (!(player instanceof EntityPlayerMP) || player.field_70128_L) {
            return;
        }
        boolean aid = player.func_70660_b(AoVPotions.aid) != null;
        boolean zeal = player.func_70660_b(AoVPotions.zeal) != null;
        boolean ewer = player.func_70660_b(AoVPotions.ewer) != null;
        boolean balance = player.func_70660_b(AoVPotions.balance) != null;
        boolean spire = player.func_70660_b(AoVPotions.spire) != null;
        boolean bl = spear = player.func_70660_b(AoVPotions.spear) != null;
        if (this.hasAid != aid || this.hasZeal != zeal || this.hasEwer != ewer || this.hasBalance != balance || this.hasSpire != spire || this.hasSpear != spear) {
            this.hasAid = aid;
            this.hasZeal = zeal;
            this.hasEwer = ewer;
            this.hasBalance = balance;
            this.hasSpire = spire;
            this.hasSpear = spear;
            this.markDirty();
        }
    }

    private void updateHealth(@Nullable EntityPlayer player) {
        if (player == null || player.field_70170_p == null || player.field_70170_p.field_72995_K) {
            return;
        }
        IAttributeInstance hp = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        for (AttributeModifier mod : hp.func_111122_c()) {
            if (!HEALTH_NAMES.contains(mod.func_111166_b())) continue;
            hp.func_111124_b(mod);
        }
        if (this.hasSkill(AoVSkills.paladin_tier_4_2) && !hp.func_180374_a(PALADIN_HEALTH) && player.func_184592_cb().func_77973_b().isShield(player.func_184592_cb(), (EntityLivingBase)player)) {
            hp.func_111121_a(PALADIN_HEALTH);
        }
        if (this.getCoreSkill() == AoVSkills.druid_core_1 && IAoVCapability.isCentered((EntityLivingBase)player, this)) {
            hp.func_111121_a(new AttributeModifier(DRUID_HEALTH_NAME, (double)this.getLevel(), 0));
        }
    }

    private void updateValues(@Nullable EntityPlayer player) {
        IAstroCapability astro = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.ASTRO);
        this.maxLevel = (Integer)AoV.config.maxlevel.get();
        this.skillPoints = this.getLevel();
        this.spellpower = 0.0f;
        this.extraCharges = 0;
        this.dodge = 0;
        this.doublestrike = 0;
        this.selectiveFocus = false;
        this.hasInvoke = false;
        ArrayList<AbilityBase> list = new ArrayList<AbilityBase>();
        this.obtainedSkills.removeIf(Objects::isNull);
        for (AoVSkill skill : this.obtainedSkills) {
            if (skill == null) continue;
            this.skillPoints -= skill.getCost();
            this.spellpower += (float)skill.getSpellPower();
            this.extraCharges += skill.getCharges();
            this.dodge += skill.getDodge();
            this.doublestrike += skill.getDoubleStrike();
            if (AoVSkills.isSelectiveFocusSkill(skill)) {
                this.selectiveFocus = true;
            }
            for (AbilityBase ability : skill.getAbilities()) {
                if (ability == Abilities.invokeMass) {
                    this.hasInvoke = true;
                }
                list.add(ability);
            }
        }
        if (this.getCoreSkill() == AoVSkills.druid_core_1 && IAoVCapability.isCentered((EntityLivingBase)player, this)) {
            int level = this.getLevel();
            this.dodge += level;
            this.doublestrike += level;
            this.spellpower += (float)(5 * level);
            if (this.hasSkill(AoVSkills.druid_core_3)) {
                this.dodge += 25;
            }
            if (this.hasSkill(AoVSkills.druid_capstone)) {
                this.dodge += 25;
            }
        }
        Iterator<Ability> iter = this.abilities.iterator();
        block2: while (iter.hasNext()) {
            Ability check = iter.next();
            for (AbilityBase ability : list) {
                if (check.getAbility() != ability) continue;
                continue block2;
            }
            iter.remove();
        }
        for (AbilityBase ability : list) {
            boolean flag = true;
            for (Ability check : this.abilities) {
                if (check.getAbility() != ability) continue;
                flag = false;
            }
            if (!flag) continue;
            this.addAbility(new Ability(ability, this, astro));
        }
        if (player != null && player.field_70170_p != null && !player.field_70170_p.field_72995_K) {
            for (int index = 0; index < 9; ++index) {
                if (this.slots[index] == null) continue;
                boolean flag = true;
                for (Ability check : this.abilities) {
                    if (check.getAbility() != this.slots[index].getAbility()) continue;
                    this.slots[index] = check;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                this.slots[index] = null;
            }
        }
        if (player != null) {
            PotionEffect balance;
            PotionEffect spear;
            PotionEffect spire;
            IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH);
            if (poly != null) {
                if (poly.getMorph() == IPolymorphCapability.Morph.Wolf) {
                    this.doublestrike += 15;
                    this.dodge += 10;
                } else if (poly.getMorph() == IPolymorphCapability.Morph.ArchAngel) {
                    this.spellpower += 75.0f;
                    this.dodge += 25;
                } else if (poly.getMorph() == IPolymorphCapability.Morph.FireElemental && player.field_70170_p.func_72820_D() % 24000L < 12000L) {
                    this.spellpower += 20.0f;
                } else if (poly.getMorph() == IPolymorphCapability.Morph.WaterElemental && player.field_70170_p.func_72820_D() % 24000L >= 12000L) {
                    this.spellpower += 20.0f;
                }
            }
            if (player.func_70660_b(AoVPotions.aid) != null) {
                this.dodge += 5;
            }
            if (player.func_70660_b(AoVPotions.zeal) != null) {
                this.doublestrike += 25;
            }
            if ((spire = player.func_70660_b(AoVPotions.spire)) != null) {
                this.dodge += 10 * (spire.func_76458_c() + 1);
            }
            if ((spear = player.func_70660_b(AoVPotions.spear)) != null) {
                this.doublestrike += 10 * (spear.func_76458_c() + 1);
            }
            if ((balance = player.func_70660_b(AoVPotions.balance)) != null) {
                this.spellpower += (float)(50 * (balance.func_76458_c() + 1));
            }
        }
    }

    private void updateAbilities(@Nullable EntityPlayer player) {
        for (Ability ability : this.slots) {
            if (ability == null) continue;
            ability.update(player, this);
        }
        if (this.tick % 20 == 0) {
            Iterator<Map.Entry<AbilityBase, Integer>> iter = this.cooldowns.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<AbilityBase, Integer> entry = iter.next();
                entry.setValue(entry.getValue() - 1);
                if (entry.getValue() > 0) continue;
                iter.remove();
            }
        }
    }

    private void updateAuras(@Nullable EntityPlayer player) {
        Iterator<Aura> iter = this.auras.iterator();
        while (iter.hasNext()) {
            Aura aura = iter.next();
            if (player != null && !player.field_70170_p.field_72995_K || aura.getSpell().getAbility().runOnClient()) {
                aura.update(player);
            }
            if (!aura.removed()) continue;
            iter.remove();
        }
    }

    private void updateDecay() {
        Iterator<DecayWrapper> iter = this.decay.values().iterator();
        while (iter.hasNext()) {
            DecayWrapper wrapper = iter.next();
            wrapper.update();
            if (wrapper.getDecay() > 0) continue;
            iter.remove();
        }
    }

    @Override
    public void setCooldown(AbilityBase ability, int cd) {
        this.cooldowns.put(ability, cd);
    }

    @Override
    public int getCooldown(AbilityBase ability) {
        return this.cooldowns.getOrDefault(ability, 0);
    }

    @Override
    public Map<AbilityBase, Integer> getCooldowns() {
        return Collections.unmodifiableMap(this.cooldowns);
    }

    @Override
    public void setCooldowns(Map<AbilityBase, Integer> map) {
        this.cooldowns.clear();
        for (Map.Entry<AbilityBase, Integer> entry : map.entrySet()) {
            this.cooldowns.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void resetCharges(EntityPlayer player) {
        this.cooldowns.clear();
        this.decay.clear();
        for (Ability ability : this.slots) {
            if (ability == null) continue;
            ability.reset(player, this);
        }
        this.dirty = true;
    }

    @Override
    public void restoreCharges(EntityLivingBase caster, int amount) {
        for (Ability ability : this.slots) {
            if (ability == null) continue;
            ability.restoreCharge(caster, this, amount);
        }
        this.dirty = true;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean canUseAbility(Ability ability) {
        this.dirty = true;
        boolean flag = false;
        for (Ability a : this.abilities) {
            if (!a.compare(ability) || !ability.canUse(this)) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public void addAbility(Ability ability) {
        for (Ability check : this.abilities) {
            if (check.getAbility() != ability.getAbility()) continue;
            return;
        }
        this.abilities.add(ability);
        this.dirty = true;
    }

    @Override
    public void removeAbility(Ability ability) {
        Iterator<Ability> iter = this.abilities.iterator();
        while (iter.hasNext()) {
            Ability a = iter.next();
            if (!a.compare(ability)) continue;
            iter.remove();
            this.dirty = true;
        }
    }

    @Override
    public void clearAuras() {
        this.auras.clear();
    }

    @Override
    public void addAura(Aura aura) {
        this.auras.removeIf(a -> a.equals(aura));
        this.auras.add(aura);
        this.dirty = true;
    }

    @Override
    public <T> boolean isAuraActive(T aura) {
        return this.auras.stream().anyMatch(a -> a.getAsAura() == aura);
    }

    @Override
    public List<Aura> getAuras() {
        return Collections.unmodifiableList(this.auras);
    }

    @Override
    public void addExp(Entity player, int amount, AbilityBase spell) {
        if (!this.hasCoreSkill() || this.getLevel() >= this.getMaxLevel()) {
            return;
        }
        if (spell != null) {
            if (this.decay.containsKey(spell)) {
                int dec = this.decay.get(spell).getDecay();
                if (dec > 0) {
                    amount /= dec;
                }
                this.decay.get(spell).addDecay();
            } else {
                this.decay.put(spell, new DecayWrapper());
            }
        }
        int tempLevel = this.getLevel();
        this.exp += amount;
        if (player instanceof EntityPlayerMP) {
            FloatyTextHelper.sendText((EntityPlayer)((EntityPlayerMP)player), "+" + amount + " Exp");
            if (this.getLevel() > tempLevel) {
                FloatyTextHelper.sendText((EntityPlayer)((EntityPlayerMP)player), "Level Up! (" + this.getLevel() + ")");
            }
        }
        this.dirty = true;
    }

    @Override
    public void addObtainedSkill(AoVSkill skill) {
        if (!(skill == null || this.obtainedSkills.contains(skill) || skill.isClassCore() && this.hasCoreSkill())) {
            this.obtainedSkills.add(skill);
            this.dirty = true;
        }
    }

    @Override
    public boolean hasSkill(AoVSkill skill) {
        return this.obtainedSkills.contains(skill);
    }

    @Override
    public boolean hasCoreSkill() {
        for (AoVSkill skill : this.obtainedSkills) {
            if (!skill.isClassCore()) continue;
            return true;
        }
        return false;
    }

    @Override
    public AoVSkill getCoreSkill() {
        for (AoVSkill skill : this.obtainedSkills) {
            if (!skill.isClassCore()) continue;
            return skill;
        }
        return null;
    }

    @Override
    public List<AoVSkill> getObtainedSkills() {
        return this.obtainedSkills;
    }

    @Override
    public void removeSkill(AoVSkill skill) {
        this.obtainedSkills.remove(skill);
        this.dirty = true;
    }

    @Override
    public int getLevel() {
        return AoVCapabilityHandler.getLevelFromExp(this.exp);
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public void setMaxLevel(int amount) {
        this.maxLevel = amount;
        this.dirty = true;
    }

    @Override
    public int getExp() {
        return this.exp;
    }

    @Override
    public void setExp(int amount) {
        this.exp = amount;
        this.dirty = true;
    }

    @Override
    public int getExpNeededToLevel() {
        return this.getLevel() >= this.maxLevel ? 0 : AoVCapabilityHandler.getExpForLevel(this, this.getLevel() + 1) - this.exp;
    }

    @Override
    public int getSkillPoints() {
        return this.skillPoints;
    }

    @Override
    public void setSkillPoints(int amount) {
        this.skillPoints = amount;
        this.dirty = true;
    }

    @Override
    public int getSpentSkillPoints() {
        return this.getLevel() - this.skillPoints;
    }

    @Override
    public float getSpellPower() {
        return this.spellpower;
    }

    @Override
    public int getExtraCharges(EntityLivingBase caster, Ability ability) {
        return this.extraCharges + (caster == null || ability == null ? 0 : ability.getAbility().getExtraCharges(caster, this));
    }

    @Override
    public int getDodge() {
        return this.dodge;
    }

    @Override
    public int getDoubleStrike() {
        return this.doublestrike;
    }

    @Override
    public boolean hasSelectiveFocus() {
        return this.selectiveFocus;
    }

    @Override
    public void toggleInvokeMass(boolean b) {
        this.invokeMass = this.hasInvoke && b;
        this.dirty = true;
    }

    @Override
    public void toggleInvokeMass() {
        this.invokeMass = this.hasInvoke && !this.invokeMass;
        this.dirty = true;
    }

    @Override
    public boolean getInvokeMass() {
        return this.invokeMass;
    }

    @Override
    public boolean hasInvokeMass() {
        return this.hasInvoke;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void cast(int slotLoc) {
        int[] nArray;
        if (ClientProxy.getTarget() != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = slotLoc;
            nArray = nArray2;
            nArray2[1] = ClientProxy.getTarget().func_145782_y();
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = slotLoc;
        }
        AoV.network.sendToServer((Object)new ServerPacketHandlerSpellSkill(ServerPacketHandlerSpellSkill.PacketType.CAST_SPELL, null, nArray));
        Ability ability = this.getSlot(slotLoc);
        if (ability != null && ability.getAbility().runOnClient()) {
            if (ClientProxy.getTarget() == null) {
                ability.cast((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            } else {
                ability.cast((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ClientProxy.getTarget());
            }
        }
    }

    @Override
    public void setSlot(Ability ability, int slot, boolean force) {
        if (force) {
            this.slots[slot] = ability;
            this.dirty = true;
            return;
        }
        for (Ability check : this.getAbilities()) {
            if (ability != null && !check.compare(ability) || slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot] = ability == null ? null : check;
            break;
        }
        this.dirty = true;
    }

    @Override
    public Ability getSlot(int slot) {
        return slot >= 0 && slot < this.slots.length ? this.slots[slot] : null;
    }

    @Override
    public int getSlotFromAbility(AbilityBase ability) {
        int index = 0;
        for (Ability a : this.slots) {
            if (a != null && ability == a.getAbility()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int getCurrentSlot() {
        return this.currentSlot;
    }

    @Override
    public void setCurrentSlot(int index) {
        this.currentSlot = index;
        this.dirty = true;
    }

    @Override
    public boolean slotsContain(AbilityBase ability) {
        for (Ability a : this.slots) {
            if (a == null || ability != a.getAbility()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addToNearestSlot(AbilityBase ability) {
        if (this.slotsContain(ability)) {
            return;
        }
        Ability a = null;
        if (ability != null) {
            for (Ability check : this.abilities) {
                if (check.getAbility() != ability) continue;
                a = check;
                break;
            }
        }
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] != null) continue;
            this.setSlot(a, i, false);
            break;
        }
        this.dirty = true;
    }

    @Override
    public void removeSlot(int slot) {
        if (slot >= 0 && slot < this.slots.length) {
            this.slots[slot] = null;
        }
        this.dirty = true;
    }

    @Override
    public void clearAllSlots() {
        this.slots = new Ability[]{null, null, null, null, null, null, null, null, null};
        this.dirty = true;
    }

    @Override
    public void copyFrom(IAoVCapability cap) {
        this.obtainedSkills = cap.getObtainedSkills();
        this.skillPoints = cap.getSkillPoints();
        this.exp = cap.getExp();
        this.maxLevel = cap.getMaxLevel();
        this.invokeMass = cap.getInvokeMass();
        this.abilities = cap.getAbilities();
        for (int index = 0; index < 9; ++index) {
            this.slots[index] = cap.getSlot(index);
        }
        this.currentSlot = cap.getCurrentSlot();
        this.setDecayMap(cap.getDecayMap());
        this.hasLoaded = true;
        this.dirty = true;
    }

    @Override
    public Map<AbilityBase, DecayWrapper> getDecayMap() {
        return Collections.unmodifiableMap(this.decay);
    }

    @Override
    public void setDecayMap(Map<AbilityBase, DecayWrapper> map) {
        this.decay.clear();
        this.decay.putAll(map);
    }

    @Override
    public Ability[] getSlots() {
        return this.slots;
    }

    private void sendPacketUpdates(EntityPlayerMP player) {
        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH);
        if (poly == null) {
            return;
        }
        AoV.network.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new ClientPacketHandlerAoVData(this, poly));
    }

    protected class DecayWrapper {
        private int amount;
        private int tick = 0;
        private int decayTick = 600;

        public DecayWrapper(int a) {
            this.amount = a;
        }

        public DecayWrapper() {
            this(1);
        }

        public void addDecay() {
            ++this.amount;
        }

        public void update() {
            ++this.tick;
            if (this.tick % this.decayTick == 0) {
                --this.amount;
            }
        }

        public int getDecay() {
            return this.amount;
        }
    }
}

