/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.aov;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.aov.AoVCapabilityHandler;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.skills.AoVSkill;
import tamaized.aov.common.core.skills.AoVSkills;

public class AoVCapabilityStorage
implements Capability.IStorage<IAoVCapability> {
    public INBTBase writeNBT(Capability<IAoVCapability> capability, IAoVCapability instance, EnumFacing side) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (AoVSkill aoVSkill : instance.getObtainedSkills()) {
            list.add((INBTBase)new NBTTagInt(aoVSkill.getID()));
        }
        nbt.func_74782_a("obtainedSkills", (INBTBase)list);
        list = new NBTTagList();
        for (Map.Entry entry : instance.getDecayMap().entrySet()) {
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74768_a("id", AbilityBase.getID((AbilityBase)entry.getKey()));
            comp.func_74768_a("decay", ((AoVCapabilityHandler.DecayWrapper)entry.getValue()).getDecay());
            list.add((INBTBase)comp);
        }
        nbt.func_74782_a("decay", (INBTBase)list);
        nbt.func_74768_a("skillPoints", instance.getSkillPoints());
        nbt.func_74768_a("exp", instance.getExp());
        nbt.func_74768_a("maxLevel", instance.getMaxLevel());
        nbt.func_74757_a("invokeMass", instance.getInvokeMass());
        list = new NBTTagList();
        for (int index = 0; index < 9; ++index) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            Ability ability = instance.getSlot(index);
            nBTTagCompound.func_74768_a("slot", index);
            nBTTagCompound.func_74768_a("id", ability == null ? -1 : ability.getAbility().getID());
            list.add((INBTBase)nBTTagCompound);
        }
        nbt.func_74782_a("slots", (INBTBase)list);
        list = new NBTTagList();
        for (Ability ability : instance.getAbilities()) {
            list.add((INBTBase)ability.encode(new NBTTagCompound(), instance));
        }
        nbt.func_74782_a("abilities", (INBTBase)list);
        nbt.func_74768_a("currentSlot", instance.getCurrentSlot());
        return nbt;
    }

    public void readNBT(Capability<IAoVCapability> capability, IAoVCapability instance, EnumFacing side, INBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        INBTBase tag = compound.func_74781_a("obtainedSkills");
        if (tag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag;
            for (int index = 0; index < list.size(); ++index) {
                instance.addObtainedSkill(AoVSkills.getSkillFromID(list.func_186858_c(index)));
            }
        }
        HashMap<AbilityBase, AoVCapabilityHandler.DecayWrapper> decay = new HashMap<AbilityBase, AoVCapabilityHandler.DecayWrapper>();
        tag = compound.func_74781_a("decay");
        if (tag instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)tag;
            for (int index = 0; index < list.size(); ++index) {
                NBTTagCompound comp = list.func_150305_b(index);
                AbilityBase abilityBase = AbilityBase.getAbilityFromID(comp.func_74762_e("id"));
                AoVCapabilityHandler aoVCapabilityHandler = (AoVCapabilityHandler)instance;
                aoVCapabilityHandler.getClass();
                decay.put(abilityBase, aoVCapabilityHandler.new AoVCapabilityHandler.DecayWrapper(comp.func_74762_e("decay")));
            }
        }
        if (!decay.isEmpty()) {
            instance.setDecayMap(decay);
        }
        instance.setSkillPoints(compound.func_74762_e("skillPoints"));
        instance.setExp(compound.func_74762_e("exp"));
        instance.setMaxLevel((Integer)AoV.config.maxlevel.get());
        instance.toggleInvokeMass(compound.func_74767_n("invokeMass"));
        instance.update(null);
        tag = compound.func_74781_a("abilities");
        if (tag instanceof NBTTagList) {
            for (INBTBase nt : (NBTTagList)tag) {
                if (!(nt instanceof NBTTagCompound)) continue;
                instance.addAbility(Ability.construct(instance, null, (NBTTagCompound)nt));
            }
        }
        if ((tag = compound.func_74781_a("slots")) instanceof NBTTagList) {
            for (INBTBase nt : (NBTTagList)tag) {
                if (!(nt instanceof NBTTagCompound)) continue;
                NBTTagCompound ct = (NBTTagCompound)nt;
                instance.setSlot(new Ability(AbilityBase.getAbilityFromID(ct.func_74762_e("id"))), ct.func_74762_e("slot"), false);
            }
        }
        instance.setCurrentSlot(compound.func_74762_e("currentSlot"));
        instance.markDirty();
        instance.setLoaded();
    }
}

