/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.aov;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import tamaized.aov.common.capabilities.aov.AoVCapabilityHandler;
import tamaized.aov.common.config.ConfigHandler;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.Aura;
import tamaized.aov.common.core.skills.AoVSkill;
import tamaized.aov.common.core.skills.AoVSkills;

public interface IAoVCapability {
    public static final ResourceLocation ID = new ResourceLocation("aov", "aovcapabilityhandler");

    public static boolean selectiveTarget(@Nullable Entity caster, @Nullable IAoVCapability cap, EntityLivingBase entity) {
        return caster != entity && (cap == null || !cap.hasSelectiveFocus() || caster == null || caster.func_96124_cp() != null && !caster.func_184191_r((Entity)entity) || (!(entity instanceof IEntityOwnable) || ((IEntityOwnable)entity).func_70902_q() != caster) && !(entity instanceof EntityPlayer) && (!(entity instanceof IAnimal) || entity instanceof IMob));
    }

    public static boolean canBenefit(Entity caster, IAoVCapability cap, EntityLivingBase entity) {
        return !cap.hasSelectiveFocus() || !IAoVCapability.selectiveTarget(caster, cap, entity);
    }

    public static boolean isCentered(EntityLivingBase entity, IAoVCapability cap) {
        if (entity != null && cap != null && cap.hasSkill(AoVSkills.druid_core_1)) {
            for (ItemStack stack : entity.func_184193_aE()) {
                if (stack.func_190926_b() || ItemStackWrapper.compareItems(ConfigHandler.CENTERED_WEAR, stack)) continue;
                return false;
            }
            if (!entity.func_184614_ca().func_190926_b() && !ItemStackWrapper.compareItems(ConfigHandler.CENTERED_WEAR, entity.func_184614_ca())) {
                return !entity.func_184614_ca().func_111283_C(EntityEquipmentSlot.MAINHAND).containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            }
            return entity.func_184592_cb().func_190926_b() || ItemStackWrapper.compareItems(ConfigHandler.CENTERED_WEAR, entity.func_184592_cb()) || !entity.func_184592_cb().func_111283_C(EntityEquipmentSlot.OFFHAND).containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        }
        return false;
    }

    public static boolean isImprovedCentered(EntityLivingBase entity, IAoVCapability cap) {
        return cap != null && cap.hasSkill(AoVSkills.druid_core_4) && IAoVCapability.isCentered(entity, cap);
    }

    public void markDirty();

    public void setLoaded();

    public void reset(boolean var1);

    public void update(EntityPlayer var1);

    public void setCooldown(AbilityBase var1, int var2);

    public int getCooldown(AbilityBase var1);

    public Map<AbilityBase, Integer> getCooldowns();

    public void setCooldowns(Map<AbilityBase, Integer> var1);

    public void resetCharges(EntityPlayer var1);

    public void restoreCharges(EntityLivingBase var1, int var2);

    public List<Ability> getAbilities();

    public boolean canUseAbility(Ability var1);

    public void addAbility(Ability var1);

    public void removeAbility(Ability var1);

    public void clearAuras();

    public void addAura(Aura var1);

    public <T> boolean isAuraActive(T var1);

    public List<Aura> getAuras();

    public void addExp(Entity var1, int var2, AbilityBase var3);

    public void addObtainedSkill(AoVSkill var1);

    public boolean hasSkill(AoVSkill var1);

    public boolean hasCoreSkill();

    public AoVSkill getCoreSkill();

    public List<AoVSkill> getObtainedSkills();

    public void removeSkill(AoVSkill var1);

    public int getLevel();

    public int getMaxLevel();

    public void setMaxLevel(int var1);

    public int getExp();

    public void setExp(int var1);

    public int getExpNeededToLevel();

    public int getSkillPoints();

    public void setSkillPoints(int var1);

    public int getSpentSkillPoints();

    public float getSpellPower();

    public int getExtraCharges(@Nullable EntityLivingBase var1, @Nullable Ability var2);

    public int getDodge();

    default public int getDodgeForRand() {
        return Math.round(100.0f / (float)this.getDodge());
    }

    public int getDoubleStrike();

    default public int getDoubleStrikeForRand() {
        return Math.round(100.0f / (float)this.getDoubleStrike());
    }

    public boolean hasSelectiveFocus();

    public void toggleInvokeMass(boolean var1);

    public void toggleInvokeMass();

    public boolean getInvokeMass();

    public boolean hasInvokeMass();

    public void cast(int var1);

    public void setSlot(Ability var1, int var2, boolean var3);

    public Ability getSlot(int var1);

    public int getSlotFromAbility(AbilityBase var1);

    default public Ability getAbilityFromSlots(AbilityBase ability) {
        return this.getSlot(this.getSlotFromAbility(ability));
    }

    public int getCurrentSlot();

    public void setCurrentSlot(int var1);

    public boolean slotsContain(AbilityBase var1);

    public void addToNearestSlot(AbilityBase var1);

    public void removeSlot(int var1);

    public void clearAllSlots();

    public Map<AbilityBase, AoVCapabilityHandler.DecayWrapper> getDecayMap();

    public void setDecayMap(Map<AbilityBase, AoVCapabilityHandler.DecayWrapper> var1);

    public void copyFrom(IAoVCapability var1);

    public Ability[] getSlots();

    public static class ItemStackWrapper {
        boolean ignoreNBT;
        ItemStack stack;

        public ItemStackWrapper(IItemProvider item) {
            this(new ItemStack(item), true);
        }

        public ItemStackWrapper(NBTTagCompound tag, boolean ignoreNBT) {
            this(ItemStack.func_199557_a((NBTTagCompound)tag), ignoreNBT);
        }

        public ItemStackWrapper(ItemStack stack, boolean ignoreNBT) {
            this.stack = stack;
            this.ignoreNBT = ignoreNBT;
        }

        public static boolean compareItems(Set<Item> set, ItemStack stack) {
            for (Item item : set) {
                if (stack.func_77973_b() != item) continue;
                return true;
            }
            return false;
        }

        public static boolean compare(Set<ItemStackWrapper> set, ItemStack stack) {
            for (ItemStackWrapper wrapper : set) {
                boolean flag = wrapper.ignoreNBT ? wrapper.stack.func_77969_a(stack) : ItemStack.func_77989_b((ItemStack)wrapper.stack, (ItemStack)stack);
                if (!flag) continue;
                return true;
            }
            return false;
        }

        public ItemStackWrapper attachNBT(NBTTagCompound tag) {
            this.ignoreNBT = false;
            this.stack.func_77982_d(tag);
            return this;
        }
    }
}

