/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.astro;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Particles;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.network.PacketDistributor;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.network.client.ClientPacketHandlerAstroAnimation;
import tamaized.aov.network.client.ClientPacketHandlerAstroData;
import tamaized.aov.registry.SoundEvents;

public class AstroCapabilityHandler
implements IAstroCapability {
    public IAstroCapability.ICard lastDraw;
    public IAstroCapability.ICard lastSpread;
    private int tick;
    private float[][] frameData = new float[IAstroCapability.IAnimation.values.length][6];
    private IAstroCapability.IAnimation[] animations = new IAstroCapability.IAnimation[IAstroCapability.IAnimation.values.length];
    private IAstroCapability.ICard draw;
    private int drawTime;
    private IAstroCapability.ICard burn;
    private IAstroCapability.ICard spread;
    private boolean dirty = true;

    private static void spawnParticle(EntityLivingBase entity, double x, double y, double z) {
        entity.field_70170_p.func_195594_a((IParticleData)Particles.field_197607_R, x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public IAstroCapability.IAnimation[] getAnimations() {
        return this.animations;
    }

    @Override
    public void playAnimation(EntityLivingBase entity, IAstroCapability.IAnimation animation) {
        if (animation == null) {
            return;
        }
        switch (animation) {
            default: {
                this.animations[0] = animation;
                this.frameData[0][0] = 80.0f;
                this.frameData[0][1] = 80.0f;
                this.frameData[0][2] = 180.0f;
                this.frameData[0][3] = 100.0f;
                this.frameData[0][4] = 0.0f;
                this.frameData[0][5] = 0.0f;
                if (entity.field_70170_p.field_72995_K) break;
                SoundEvents.playMovingSoundOnServer(SoundEvents.draw1, (Entity)entity);
                break;
            }
            case Burn: {
                this.animations[1] = animation;
                this.frameData[1][0] = 80.0f;
                this.frameData[1][1] = 90.0f;
                this.frameData[1][2] = 0.0f;
                this.frameData[1][3] = 35.0f;
                this.frameData[1][4] = 0.0f;
                this.frameData[1][5] = 0.0f;
                if (entity.field_70170_p.field_72995_K) break;
                SoundEvents.playMovingSoundOnServer(SoundEvents.burn, (Entity)entity);
                break;
            }
            case Spread: {
                this.animations[2] = animation;
                this.frameData[2][0] = 80.0f;
                this.frameData[2][1] = 80.0f;
                this.frameData[2][2] = 180.0f;
                this.frameData[2][3] = 100.0f;
                this.frameData[2][4] = 0.0f;
                this.frameData[2][5] = 0.0f;
                if (entity.field_70170_p.field_72995_K) break;
                SoundEvents.playMovingSoundOnServer(SoundEvents.spread, (Entity)entity);
                break;
            }
            case Activate: {
                this.animations[3] = animation;
                this.frameData[3][0] = 80.0f;
                this.frameData[3][1] = 90.0f;
                this.frameData[3][2] = 0.0f;
                this.frameData[3][3] = 35.0f;
                this.frameData[3][4] = 0.0f;
                this.frameData[3][5] = 0.0f;
                if (entity.field_70170_p.field_72995_K) break;
                SoundEvents.playMovingSoundOnServer(SoundEvents.activate, (Entity)entity);
                break;
            }
            case Redraw: {
                this.animations[4] = animation;
                this.frameData[4][0] = 400.0f;
                this.frameData[4][1] = 80.0f;
                this.frameData[4][2] = 200.0f;
                this.frameData[4][3] = 100.0f;
                this.frameData[4][4] = 110.0f;
                this.frameData[4][5] = 0.0f;
                this.animations[0] = IAstroCapability.IAnimation.Draw;
                this.frameData[0][0] = 80.0f;
                this.frameData[0][1] = 80.0f;
                this.frameData[0][2] = 180.0f;
                this.frameData[0][3] = 100.0f;
                this.frameData[0][4] = 0.0f;
                this.frameData[0][5] = 0.0f;
                if (entity.field_70170_p.field_72995_K) break;
                SoundEvents.playMovingSoundOnServer(SoundEvents.redraw, (Entity)entity);
            }
        }
        if (!entity.field_70170_p.field_72995_K) {
            AoV.network.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new ClientPacketHandlerAstroAnimation(entity, animation));
        }
    }

    @Override
    public void updateFrameData(float[][] data) {
        this.frameData = data;
    }

    @Override
    public float[][] getFrameData() {
        return this.frameData;
    }

    @Override
    public void drawCard(EntityLivingBase entity) {
        if (this.getDraw() == null) {
            this.draw = IAstroCapability.ICard.getRandomCard();
            this.drawTime = 30;
            this.playAnimation(entity, IAstroCapability.IAnimation.Draw);
        }
    }

    @Override
    public void redrawCard(EntityLivingBase entity) {
        if (this.getDraw() != null) {
            IAstroCapability.ICard newDraw = this.draw;
            while (newDraw == this.draw) {
                newDraw = IAstroCapability.ICard.getRandomCard();
            }
            this.draw = newDraw;
            this.playAnimation(entity, IAstroCapability.IAnimation.Redraw);
            this.drawTime = 30;
        }
    }

    @Override
    public void burnCard(EntityLivingBase entity) {
        if (this.getDraw() != null) {
            this.burn = this.getDraw();
            this.draw = null;
            this.drawTime = 0;
            this.playAnimation(entity, IAstroCapability.IAnimation.Burn);
        }
    }

    @Override
    public void spreadCard(EntityLivingBase entity) {
        if (this.getDraw() != null) {
            this.spread = this.getDraw();
            this.draw = null;
            this.drawTime = 0;
            this.playAnimation(entity, IAstroCapability.IAnimation.Spread);
        }
    }

    @Override
    public int getDrawTime() {
        return this.drawTime;
    }

    @Override
    public void setDrawTime(int drawTime) {
        this.drawTime = drawTime;
    }

    @Override
    @Nullable
    public IAstroCapability.ICard getDraw() {
        return this.draw;
    }

    @Override
    public void setDraw(IAstroCapability.ICard card) {
        this.draw = card;
    }

    @Override
    @Nullable
    public IAstroCapability.ICard getBurn() {
        return this.burn;
    }

    @Override
    public void setBurn(IAstroCapability.ICard card) {
        this.burn = card;
    }

    @Override
    @Nullable
    public IAstroCapability.ICard getSpread() {
        return this.spread;
    }

    @Override
    public void setSpread(IAstroCapability.ICard card) {
        this.spread = card;
    }

    @Override
    public void useDraw(EntityLivingBase entity) {
        this.playAnimation(entity, IAstroCapability.IAnimation.Activate);
        this.draw = null;
        this.burn = null;
        this.drawTime = 0;
    }

    @Override
    public void useSpread(EntityLivingBase entity) {
        this.playAnimation(entity, IAstroCapability.IAnimation.Activate);
        this.spread = null;
        this.burn = null;
    }

    @Override
    public void update(EntityLivingBase entity) {
        if (this.lastDraw != this.draw && this.draw != null) {
            this.lastDraw = this.draw;
        }
        if (this.lastSpread != this.spread && this.spread != null) {
            this.lastSpread = this.spread;
        }
        int index = 0;
        for (float[] dat : this.frameData) {
            IAstroCapability.IAnimation animation = this.animations[index];
            if (dat[3] > 0.0f) {
                float[] fArray = this.frameData[index];
                fArray[3] = fArray[3] - 1.0f;
            } else if (animation != null) {
                this.animations[index] = null;
                animation = null;
            }
            if (animation != null) {
                switch (animation) {
                    case Draw: 
                    case Spread: {
                        if (dat[3] < 90.0f && dat[1] > 0.0f) {
                            for (int i = 0; i < 15; ++i) {
                                AstroCapabilityHandler.spawnParticle(entity, entity.field_70165_t + entity.func_70681_au().nextDouble() * 0.75 - 0.375, entity.field_70163_u + 2.7 + entity.func_70681_au().nextGaussian() * 0.25, entity.field_70161_v + entity.func_70681_au().nextDouble() * 0.75 - 0.375);
                            }
                        }
                        if (dat[0] > 0.0f && dat[3] < 25.0f) {
                            for (int x = 0; x < 7; ++x) {
                                for (int z = 0; z < 7; ++z) {
                                    AstroCapabilityHandler.spawnParticle(entity, entity.field_70165_t - 0.375 + 0.13 * (double)x, entity.field_70163_u + 2.95 - 0.75 * (double)((80.0f - dat[0]) / 80.0f), entity.field_70161_v - 0.375 + 0.13 * (double)z);
                                }
                            }
                        }
                        if (dat[3] != 60.0f || entity.field_70170_p.field_72995_K) break;
                        SoundEvents.playMovingSoundOnServer(SoundEvents.draw2, (Entity)entity);
                        break;
                    }
                    case Burn: {
                        float theta = (float)Math.toRadians(dat[3] * 16.0f);
                        entity.field_70170_p.func_195594_a((IParticleData)Particles.field_197631_x, entity.field_70165_t + (double)MathHelper.func_76134_b((float)theta), entity.field_70163_u + 2.0 + (double)MathHelper.func_76126_a((float)theta), entity.field_70161_v + (double)MathHelper.func_76126_a((float)theta), 0.0, 0.0, 0.0);
                        entity.field_70170_p.func_195594_a((IParticleData)Particles.field_197631_x, entity.field_70165_t + (double)MathHelper.func_76126_a((float)theta), entity.field_70163_u + 2.0 + (double)MathHelper.func_76126_a((float)theta), entity.field_70161_v + (double)MathHelper.func_76134_b((float)theta), 0.0, 0.0, 0.0);
                        if (!(dat[3] <= 20.0f) || !(dat[3] > 0.0f)) break;
                        entity.field_70170_p.func_195594_a((IParticleData)Particles.field_197631_x, entity.field_70165_t + entity.func_70681_au().nextDouble() * 0.125 - 0.0625, entity.field_70163_u + (double)2.9f - 0.125 * (double)((80.0f - dat[0]) / 80.0f), entity.field_70161_v + entity.func_70681_au().nextDouble() * 0.125 - 0.0625, 0.0, 0.0, 0.0);
                        break;
                    }
                    case Activate: {
                        if (!(dat[3] <= 20.0f) || !(dat[3] > 0.0f)) break;
                        AstroCapabilityHandler.spawnParticle(entity, entity.field_70165_t + entity.func_70681_au().nextDouble() * 0.125 - 0.0625, entity.field_70163_u + (double)2.7f - 0.125 * (double)((80.0f - dat[0]) / 80.0f), entity.field_70161_v + entity.func_70681_au().nextDouble() * 0.125 - 0.0625);
                        break;
                    }
                }
            }
            ++index;
        }
        if (++this.tick % 20 == 0) {
            this.dirty = true;
            if (this.drawTime > 0) {
                --this.drawTime;
            } else if (this.getDraw() != null) {
                this.draw = null;
            }
            this.tick = 0;
        }
        if (this.dirty) {
            if (entity instanceof EntityPlayerMP) {
                this.sendPacketUpdates((EntityPlayer)((EntityPlayerMP)entity));
            }
            this.dirty = false;
        }
    }

    @Override
    public void sendPacketUpdates(EntityPlayer player) {
        AoV.network.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new ClientPacketHandlerAstroData(player));
    }
}

