/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.polymorph;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public interface IPolymorphCapability {
    public static final Set<Potion> ELEMENTAL_IMMUNITY_EFFECTS = ImmutableSet.of((Object)MobEffects.field_76421_d, (Object)MobEffects.field_76436_u, (Object)MobEffects.field_82731_v);
    public static final ResourceLocation ID = new ResourceLocation("aov", "polymorphcapabilityhandler");

    public Morph getMorph();

    public void morph(Morph var1);

    public boolean localMorphSize();

    public void setLocalMorphSize(boolean var1);

    public float getAttackCooldown();

    public void doAttack(EntityPlayer var1);

    public void doAttack(EntityPlayer var1, boolean var2);

    public void doAttack(EntityPlayer var1, boolean var2, int var3);

    public float getInitalAttackCooldown();

    public void callWolves(World var1, EntityPlayer var2, float var3);

    public void update(EntityPlayer var1);

    public byte getFlagBits();

    public void setFlagBits(byte var1);

    public boolean isFlagBitActive(byte var1);

    public void addFlagBits(byte var1);

    public void subtractFlagBits(byte var1);

    public static enum Morph {
        Wolf,
        FireElemental,
        WaterElemental,
        ArchAngel(tamaized.aov.registry.SoundEvents.aura, false);

        public static final Morph[] values;
        public final boolean requiresCentered;
        public final SoundEvent sound;

        private Morph() {
            this(true);
        }

        private Morph(SoundEvent sound) {
            this(sound, true);
        }

        private Morph(boolean centered) {
            this(SoundEvents.field_187514_aD, centered);
        }

        private Morph(SoundEvent sound, boolean centered) {
            this.requiresCentered = centered;
            this.sound = sound;
        }

        public static Morph getMorph(int ordinal) {
            return ordinal < 0 || ordinal >= values.length ? null : values[ordinal];
        }

        static {
            values = Morph.values();
        }
    }
}

