/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.AoV;
import tamaized.aov.common.blocks.BlockAngelicBlock;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.AoVCapabilityHandler;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.gui.GuiHandler;

public final class AoVCommands {
    private AoVCommands() {
    }

    public static class Reset {
        public static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset").requires(cs -> cs.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"full").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> Reset.run((EntityPlayer)context.getArgument("player", EntityPlayer.class), Type.FULL)))).executes(context -> Reset.run((EntityPlayer)((CommandSource)context.getSource()).func_197035_h(), Type.FULL)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"minor").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> Reset.run((EntityPlayer)context.getArgument("player", EntityPlayer.class), Type.MINOR)))).executes(context -> Reset.run((EntityPlayer)((CommandSource)context.getSource()).func_197035_h(), Type.MINOR)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"cooldown").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> Reset.run((EntityPlayer)context.getArgument("player", EntityPlayer.class), Type.COOLDOWN)))).executes(context -> Reset.run((EntityPlayer)((CommandSource)context.getSource()).func_197035_h(), Type.COOLDOWN)));
        }

        private static int run(EntityPlayer target, Type type) {
            IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)target, CapabilityList.AOV, null);
            if (cap != null) {
                switch (type) {
                    case FULL: 
                    case MINOR: {
                        cap.reset(type == Type.FULL);
                        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)target, CapabilityList.POLYMORPH);
                        if (poly == null) break;
                        poly.morph(null);
                        break;
                    }
                    case COOLDOWN: {
                        cap.resetCharges(target);
                    }
                }
            }
            return 0;
        }

        private static enum Type {
            FULL,
            MINOR,
            COOLDOWN;

        }
    }

    public static class SetLevel {
        public static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"setlevel").requires(cs -> cs.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)AoV.config.maxlevel.get()))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> SetLevel.run((EntityPlayer)context.getArgument("player", EntityPlayer.class), (Integer)context.getArgument("level", Integer.TYPE))))).executes(context -> SetLevel.run((EntityPlayer)((CommandSource)context.getSource()).func_197035_h(), (Integer)context.getArgument("level", Integer.TYPE))));
        }

        private static int run(EntityPlayer target, int level) {
            IPolymorphCapability poly;
            IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)target, CapabilityList.AOV, null);
            if (cap != null) {
                cap.reset(true);
                cap.setExp(AoVCapabilityHandler.getExpForLevel(level));
            }
            if ((poly = CapabilityList.getCap((ICapabilityProvider)target, CapabilityList.POLYMORPH, null)) != null) {
                poly.morph(null);
            }
            return 0;
        }
    }

    public static class Open {
        public static ArgumentBuilder<CommandSource, ?> register() {
            return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"open").requires(cs -> cs.func_197034_c(2))).executes(context -> {
                GuiHandler.openGui(GuiHandler.GUI.SKILLS, BlockAngelicBlock.ClassType.ALL, ((CommandSource)context.getSource()).func_197035_h());
                return 0;
            });
        }
    }
}

